/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.excel.coditional;

import com.inet.docx.document.excel.WorkbookAnalyzer;
import com.inet.docx.document.excel.coditional.CellAddressAndValue;
import com.inet.docx.document.excel.coditional.ConditionalFormatingHandler;
import com.inet.docx.document.excel.coditional.FormatingHandler;
import java.util.Calendar;
import java.util.List;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxf;

public class PeriodHandler
extends FormatingHandler {
    private double periodStart;
    private double periodEnd;

    protected PeriodHandler(int priority, ConditionalFormatingHandler formatingHandler, CTDxf format, String periodType) {
        super(priority, formatingHandler, format);
        Calendar cal = Calendar.getInstance();
        int currentDayOfWeek = cal.get(7);
        int currentDayOfMonth = cal.get(5);
        int currentMonth = cal.get(2);
        int currentYear = cal.get(1);
        cal.set(5, 1);
        cal.set(2, 0);
        cal.set(1, 1900);
        long time1900 = cal.getTimeInMillis();
        int currentDayExcel = PeriodHandler.calcExcelDay(time1900, System.currentTimeMillis());
        int startOfThisWeek = currentDayExcel - currentDayOfWeek + 1;
        int startOfThisMonth = currentDayExcel - currentDayOfMonth + 1;
        cal.set(2, currentMonth);
        cal.set(1, currentYear);
        cal.add(2, -1);
        int startOfLastMonth = PeriodHandler.calcExcelDay(time1900, cal.getTimeInMillis());
        cal.add(2, 2);
        int startOfNextMonth = PeriodHandler.calcExcelDay(time1900, cal.getTimeInMillis());
        cal.add(2, 1);
        int endOfNextMonth = PeriodHandler.calcExcelDay(time1900, cal.getTimeInMillis());
        switch (periodType) {
            case "today": {
                this.periodStart = currentDayExcel;
                this.periodEnd = currentDayExcel + 1;
                break;
            }
            case "tomorrow": {
                this.periodStart = currentDayExcel + 1;
                this.periodEnd = currentDayExcel + 2;
                break;
            }
            case "yesterday": {
                this.periodStart = currentDayExcel - 1;
                this.periodEnd = currentDayExcel;
                break;
            }
            case "last7Days": {
                this.periodStart = currentDayExcel - 6;
                this.periodEnd = currentDayExcel + 1;
                break;
            }
            case "thisWeek": {
                this.periodStart = startOfThisWeek;
                this.periodEnd = startOfThisWeek + 7;
                break;
            }
            case "lastWeek": {
                this.periodStart = startOfThisWeek - 7;
                this.periodEnd = startOfThisWeek;
                break;
            }
            case "nextWeek": {
                this.periodStart = startOfThisWeek + 7;
                this.periodEnd = startOfThisWeek + 14;
                break;
            }
            case "thisMonth": {
                this.periodStart = startOfThisMonth;
                this.periodEnd = startOfNextMonth;
                break;
            }
            case "lastMonth": {
                this.periodStart = startOfLastMonth;
                this.periodEnd = startOfThisMonth;
                break;
            }
            case "nextMonth": {
                this.periodStart = startOfNextMonth;
                this.periodEnd = endOfNextMonth;
            }
        }
    }

    @Override
    protected void checkValues(List<CellAddressAndValue> cellValues, WorkbookAnalyzer.IndexSizeAndStyle[] rows, WorkbookAnalyzer.IndexSizeAndStyle[] columns) {
        for (CellAddressAndValue cav : cellValues) {
            double numericValue;
            if (!cav.isNumeric() || !PeriodHandler.isInDisplayedRange(rows, columns, cav.getAddress()) || !((numericValue = cav.getDoubleValue().doubleValue()) >= this.periodStart) || !(numericValue < this.periodEnd)) continue;
            this.addAddress(cav.getAddress());
        }
    }

    private static int calcExcelDay(long time1900, long date) {
        long time = date - time1900;
        return (int)Math.round((double)time / 8.64E7) + 2;
    }
}

