/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.excel.coditional;

import com.inet.docx.document.elements.style.CellBorder;
import com.inet.docx.document.elements.style.LineProperties;
import com.inet.docx.document.elements.style.RunRenderInformations;
import com.inet.docx.document.elements.subelements.table.TableCell;
import com.inet.docx.document.excel.WorkbookAnalyzer;
import com.inet.docx.document.excel.coditional.CellAddressAndValue;
import com.inet.docx.document.excel.coditional.ConditionalFormatingHandler;
import com.inet.docx.document.excel.coditional.UpdateValueController;
import com.inet.docx.document.utilities.Util;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorderPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STBorderStyle;

public abstract class FormatingHandler {
    private ThemesTable themesTable;
    private IndexedColorMap indexedColorMap;
    private CTDxf format;
    private int priority;
    private boolean stopIfTrue;
    private HashSet<CellAddress> toHandle;

    protected FormatingHandler(int priority, ConditionalFormatingHandler formatingHandler, CTDxf format) {
        this.priority = priority;
        this.format = format;
        this.themesTable = formatingHandler.getThemesTable();
        this.indexedColorMap = formatingHandler.getIndexedColorMap();
        this.toHandle = new HashSet();
    }

    protected abstract void checkValues(List<CellAddressAndValue> var1, WorkbookAnalyzer.IndexSizeAndStyle[] var2, WorkbookAnalyzer.IndexSizeAndStyle[] var3);

    protected void addAddress(CellAddress cellAddress) {
        this.toHandle.add(cellAddress);
    }

    public int getPriority() {
        return this.priority;
    }

    protected boolean isStopIfTrue() {
        return this.stopIfTrue;
    }

    protected void setStopIfTrue(boolean stopIfTrue) {
        this.stopIfTrue = stopIfTrue;
    }

    protected void handleValueConditions(TableCell tc, UpdateValueController updateFlags) {
        if (this.format != null) {
            CTColor fCol;
            CTFill fill;
            if (this.format.isSetFont()) {
                CTFont ctF = this.format.getFont();
                RunRenderInformations rri = tc.getCellStyle().getFontStyle().getTextRenderInformations();
                if (!updateFlags.isForegroundSet()) {
                    updateFlags.setForegroundSet(RunRenderInformations.handleFontColor(rri, ctF, this.themesTable));
                }
                if (!updateFlags.isUnderlineSet()) {
                    updateFlags.setUnderlineSet(RunRenderInformations.handleUnderline(rri, ctF));
                }
                if (!updateFlags.isBoldSet()) {
                    updateFlags.setBoldSet(RunRenderInformations.handleBold(rri, ctF, null));
                }
                if (!updateFlags.isItalicSet()) {
                    updateFlags.setItalicSet(RunRenderInformations.handleItalic(rri, ctF, null));
                }
                if (!updateFlags.isStrikeoutSet()) {
                    updateFlags.setStrikeoutSet(RunRenderInformations.handleStrikeout(rri, ctF, null));
                }
            }
            if (this.format.isSetBorder() && !updateFlags.isBorderSet()) {
                updateFlags.setBorderSet(true);
                CTBorder borders = this.format.getBorder();
                CellBorder cb = tc.getCellStyle().getBorder();
                LineProperties line = this.getBorderLine(borders.getTop());
                if (line != null) {
                    cb.setTopLine(line);
                }
                if ((line = this.getBorderLine(borders.getLeft())) != null) {
                    cb.setLeftLine(line);
                }
                if ((line = this.getBorderLine(borders.getRight())) != null) {
                    cb.setRightLine(line);
                }
                if ((line = this.getBorderLine(borders.getBottom())) != null) {
                    cb.setBottomLine(line);
                }
            }
            if (this.format.isSetFill() && !updateFlags.isBackgroundSet() && (fill = this.format.getFill()).isSetPatternFill() && (fCol = fill.getPatternFill().getBgColor()) != null) {
                Color bg = Util.convertCtColor(fCol, this.themesTable);
                tc.getCellStyle().setCellBackground(bg);
                updateFlags.setBackgroundSet(true);
            }
        }
    }

    private LineProperties getBorderLine(CTBorderPr borderDef) {
        if (borderDef != null) {
            STBorderStyle.Enum ptrn = borderDef.getStyle();
            BorderStyle bStyle = BorderStyle.valueOf((short)((short)ptrn.intValue()));
            XSSFColor xColor = XSSFColor.from((CTColor)borderDef.getColor(), (IndexedColorMap)this.indexedColorMap);
            return WorkbookAnalyzer.convertLineStyle(bStyle, xColor);
        }
        return null;
    }

    private static boolean isAvailable(int index, WorkbookAnalyzer.IndexSizeAndStyle[] dimension) {
        for (int i = 0; i < dimension.length; ++i) {
            if (dimension[i].getIndex() != index) continue;
            return true;
        }
        return false;
    }

    protected static boolean isInDisplayedRange(WorkbookAnalyzer.IndexSizeAndStyle[] rows, WorkbookAnalyzer.IndexSizeAndStyle[] columns, CellAddress cellAddress) {
        return FormatingHandler.isAvailable(cellAddress.getColumn(), columns) && FormatingHandler.isAvailable(cellAddress.getRow(), rows);
    }

    public boolean handleFormating(TableCell tc, CellAddress cellAddress, UpdateValueController updateController) {
        if (this.toHandle.contains(cellAddress)) {
            this.handleValueConditions(tc, updateController);
            return this.stopIfTrue;
        }
        return false;
    }
}

