/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.excel.coditional;

import com.inet.docx.document.excel.WorkbookAnalyzer;
import com.inet.docx.document.excel.coditional.CellAddressAndValue;
import com.inet.docx.document.excel.coditional.ConditionalFormatingHandler;
import com.inet.docx.document.excel.coditional.FormatingHandler;
import java.util.List;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxf;

public class DuplicateAndUniqueHandler
extends FormatingHandler {
    private boolean dublicate;

    protected DuplicateAndUniqueHandler(int priority, ConditionalFormatingHandler formatingHandler, CTDxf dfx, boolean dublicate) {
        super(priority, formatingHandler, dfx);
        this.dublicate = dublicate;
    }

    @Override
    protected void checkValues(List<CellAddressAndValue> cellValues, WorkbookAnalyzer.IndexSizeAndStyle[] rows, WorkbookAnalyzer.IndexSizeAndStyle[] columns) {
        if (this.dublicate) {
            this.handleDuplicateValues(cellValues, rows, columns);
        } else {
            this.handleUniqueValues(cellValues, rows, columns);
        }
    }

    private void handleDuplicateValues(List<CellAddressAndValue> cellValues, WorkbookAnalyzer.IndexSizeAndStyle[] rows, WorkbookAnalyzer.IndexSizeAndStyle[] columns) {
        for (int i = 0; i < cellValues.size() - 1; ++i) {
            CellAddressAndValue thisValue = cellValues.get(i);
            if (CellAddressAndValue.VALUE_COMPARATOR.compare(thisValue, cellValues.get(i + 1)) != 0) continue;
            if (DuplicateAndUniqueHandler.isInDisplayedRange(rows, columns, thisValue.getAddress())) {
                this.addAddress(thisValue.getAddress());
            }
            while (i < cellValues.size() - 1 && CellAddressAndValue.VALUE_COMPARATOR.compare(thisValue, cellValues.get(i + 1)) == 0) {
                if (DuplicateAndUniqueHandler.isInDisplayedRange(rows, columns, cellValues.get(i + 1).getAddress())) {
                    this.addAddress(cellValues.get(i + 1).getAddress());
                }
                ++i;
            }
        }
    }

    private void handleUniqueValues(List<CellAddressAndValue> cellValues, WorkbookAnalyzer.IndexSizeAndStyle[] rows, WorkbookAnalyzer.IndexSizeAndStyle[] columns) {
        for (int i = 0; i < cellValues.size(); ++i) {
            CellAddressAndValue thisValue = cellValues.get(i);
            if (i == cellValues.size() - 1) {
                if (!DuplicateAndUniqueHandler.isInDisplayedRange(rows, columns, thisValue.getAddress())) continue;
                this.addAddress(thisValue.getAddress());
                continue;
            }
            CellAddressAndValue nextValue = cellValues.get(i + 1);
            if (CellAddressAndValue.VALUE_COMPARATOR.compare(thisValue, nextValue) != 0) {
                if (!DuplicateAndUniqueHandler.isInDisplayedRange(rows, columns, thisValue.getAddress())) continue;
                this.addAddress(thisValue.getAddress());
                continue;
            }
            ++i;
            while (i < cellValues.size() - 1 && CellAddressAndValue.VALUE_COMPARATOR.compare(thisValue, cellValues.get(i + 1)) == 0) {
                ++i;
            }
        }
    }
}

