/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.excel.coditional;

import com.inet.docx.document.elements.subelements.table.TableCell;
import com.inet.docx.document.excel.WorkbookAnalyzer;
import com.inet.docx.document.excel.coditional.AboveAverageHandler;
import com.inet.docx.document.excel.coditional.CellAddressAndValue;
import com.inet.docx.document.excel.coditional.ColorScaleHandler;
import com.inet.docx.document.excel.coditional.ContainsTextHandler;
import com.inet.docx.document.excel.coditional.DuplicateAndUniqueHandler;
import com.inet.docx.document.excel.coditional.FormatingHandler;
import com.inet.docx.document.excel.coditional.PeriodHandler;
import com.inet.docx.document.excel.coditional.TopPercentHandler;
import com.inet.docx.document.excel.coditional.UpdateValueController;
import com.inet.docx.document.excel.coditional.ValueRuleHandler;
import com.inet.docx.document.utilities.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.poi.ooxml.POIXMLTypeLoader;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFConditionalFormatting;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfRule;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTConditionalFormatting;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCfType;

public class ConditionalFormatingHandler {
    private ThemesTable themesTable;
    private IndexedColorMap indexedColorMap;
    List<FormatingHandler> formatingHandlerList = new ArrayList<FormatingHandler>();

    public ConditionalFormatingHandler(ThemesTable themesTable, IndexedColorMap indexedColorMap) {
        this.themesTable = themesTable;
        this.indexedColorMap = indexedColorMap;
    }

    public ThemesTable getThemesTable() {
        return this.themesTable;
    }

    public IndexedColorMap getIndexedColorMap() {
        return this.indexedColorMap;
    }

    public void init(XSSFSheet activeSheet, XSSFFormulaEvaluator formulaEvaluator, WorkbookAnalyzer.IndexSizeAndStyle[] rows, WorkbookAnalyzer.IndexSizeAndStyle[] columns) throws XmlException {
        int formatingCount = activeSheet.getSheetConditionalFormatting().getNumConditionalFormattings();
        if (formatingCount > 0) {
            XSSFWorkbook wb = activeSheet.getWorkbook();
            StylesTable st = wb.getStylesSource();
            for (int i = 0; i < formatingCount; ++i) {
                XSSFConditionalFormatting cf = activeSheet.getSheetConditionalFormatting().getConditionalFormattingAt(i);
                CellRangeAddress[] cra = cf.getFormattingRanges();
                if (!this.isRelevantCondition(cra, rows, columns)) continue;
                List<CellAddressAndValue> values = this.readCellValues(cra, activeSheet, formulaEvaluator);
                CTConditionalFormatting ctcf = (CTConditionalFormatting)CTConditionalFormatting.Factory.parse(cf.toString(), new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS));
                List rules = ctcf.getCfRuleList();
                FormatingHandler fh = null;
                for (CTCfRule rule : rules) {
                    CTDxf dfx;
                    int priority = rule.getPriority();
                    CTDxf cTDxf = dfx = rule.isSetDxfId() ? st.getDxfAt((int)rule.getDxfId()) : null;
                    if (STCfType.CELL_IS == rule.getType()) {
                        fh = new ValueRuleHandler(priority, this, dfx, rule.getOperator().toString(), rule.getFormulaList());
                    } else if (STCfType.DUPLICATE_VALUES == rule.getType() || STCfType.UNIQUE_VALUES == rule.getType()) {
                        fh = new DuplicateAndUniqueHandler(priority, this, dfx, STCfType.DUPLICATE_VALUES == rule.getType());
                    } else if (STCfType.COLOR_SCALE == rule.getType()) {
                        fh = new ColorScaleHandler(priority, this, rule.getColorScale(), values);
                    } else if (STCfType.TOP_10 == rule.getType()) {
                        fh = new TopPercentHandler(priority, this, dfx, (int)rule.getRank(), rule.isSetPercent(), rule.isSetBottom(), values.size());
                    } else if (STCfType.ABOVE_AVERAGE == rule.getType()) {
                        fh = new AboveAverageHandler(priority, this, dfx, rule.getAboveAverage());
                    } else if (STCfType.CONTAINS_TEXT == rule.getType()) {
                        fh = new ContainsTextHandler(priority, this, dfx, rule.getText());
                    } else if (STCfType.TIME_PERIOD == rule.getType()) {
                        fh = new PeriodHandler(priority, this, dfx, rule.getTimePeriod().toString());
                    } else {
                        Util.LOGGER.error((Object)("Unhandeld condition type: " + String.valueOf(rule.getType())));
                    }
                    if (fh == null) continue;
                    ((FormatingHandler)fh).checkValues(values, rows, columns);
                    fh.setStopIfTrue(rule.getStopIfTrue());
                    this.formatingHandlerList.add(fh);
                }
            }
            this.formatingHandlerList.sort(Comparator.comparingInt(o -> o.getPriority()));
            Collections.reverse(this.formatingHandlerList);
        }
    }

    private List<CellAddressAndValue> readCellValues(CellRangeAddress[] cellRanges, XSSFSheet activeSheet, XSSFFormulaEvaluator formulaEvaluator) {
        ArrayList<CellAddressAndValue> result = new ArrayList<CellAddressAndValue>();
        for (CellRangeAddress cra : cellRanges) {
            for (int columnIndex = cra.getFirstColumn(); columnIndex <= cra.getLastColumn(); ++columnIndex) {
                for (int rowIndex = cra.getFirstRow(); rowIndex <= cra.getLastRow(); ++rowIndex) {
                    XSSFCell cell;
                    XSSFRow row = activeSheet.getRow(rowIndex);
                    XSSFCell xSSFCell = cell = row != null ? row.getCell(columnIndex) : null;
                    if (cell == null) continue;
                    Object value = this.getCellValue(cell, formulaEvaluator);
                    if (value instanceof Double) {
                        result.add(new CellAddressAndValue(cell.getAddress(), (Double)value));
                        continue;
                    }
                    if (value instanceof String) {
                        result.add(new CellAddressAndValue(cell.getAddress(), (String)value));
                        continue;
                    }
                    if (!(value instanceof Boolean)) continue;
                    result.add(new CellAddressAndValue(cell.getAddress(), (Boolean)value));
                }
            }
        }
        result.sort(CellAddressAndValue.VALUE_COMPARATOR);
        return Collections.unmodifiableList(result);
    }

    private Object getCellValue(XSSFCell cell, XSSFFormulaEvaluator formulaEvaluator) {
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                return cell.getNumericCellValue();
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case FORMULA: {
                return this.getValue(formulaEvaluator.evaluate((Cell)cell));
            }
        }
        return null;
    }

    private Object getValue(CellValue cv) {
        switch (cv.getCellType()) {
            case STRING: {
                return cv.getStringValue();
            }
            case NUMERIC: {
                return cv.getNumberValue();
            }
            case BOOLEAN: {
                return cv.getBooleanValue();
            }
        }
        return null;
    }

    public void handleConditionalFormating(TableCell tc, XSSFCell cell) {
        block1: {
            if (this.formatingHandlerList.size() <= 0 || cell == null) break block1;
            CellAddress cellAddress = cell.getAddress();
            UpdateValueController updateFlags = new UpdateValueController();
            for (FormatingHandler fh : this.formatingHandlerList) {
                if (fh.handleFormating(tc, cellAddress, updateFlags)) break;
            }
        }
    }

    private boolean isRelevantCondition(CellRangeAddress[] cras, WorkbookAnalyzer.IndexSizeAndStyle[] rows, WorkbookAnalyzer.IndexSizeAndStyle[] columns) {
        for (CellRangeAddress cra : cras) {
            List<WorkbookAnalyzer.IndexSizeAndStyle> affectedTableColumns = WorkbookAnalyzer.getVisible(cra.getFirstColumn(), cra.getLastColumn(), columns);
            List<WorkbookAnalyzer.IndexSizeAndStyle> affectedTableRows = WorkbookAnalyzer.getVisible(cra.getFirstRow(), cra.getLastRow(), rows);
            if (affectedTableColumns.size() <= 0 || affectedTableRows.size() <= 0) continue;
            return true;
        }
        return false;
    }
}

