/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.excel.coditional;

import java.util.Comparator;
import org.apache.poi.ss.util.CellAddress;

public class CellAddressAndValue {
    protected static final int NUMERIC_VALUE_TYPE = 1;
    protected static final int STRING_VALUE_TYPE = 2;
    protected static final int BOOLEAN_VALUE_TYPE = 3;
    private CellAddress address;
    private Double doubleValue;
    private String stringValue;
    private Boolean booleanValue;
    public static final Comparator<CellAddressAndValue> VALUE_COMPARATOR = new Comparator<CellAddressAndValue>(){

        @Override
        public int compare(CellAddressAndValue val1, CellAddressAndValue val2) {
            if (val1.getType() == val2.getType()) {
                if (val1.getType() == 1) {
                    return val1.doubleValue.compareTo(val2.doubleValue);
                }
                if (val1.getType() == 2) {
                    return val1.stringValue.compareTo(val2.stringValue);
                }
                return val1.booleanValue.compareTo(val2.booleanValue);
            }
            return val1.getType() - val2.getType();
        }
    };

    protected CellAddressAndValue(CellAddress address, Double value) {
        this.address = address;
        this.doubleValue = value;
    }

    protected CellAddressAndValue(CellAddress address, String value) {
        this.address = address;
        this.stringValue = value;
    }

    protected CellAddressAndValue(CellAddress address, Boolean value) {
        this.address = address;
        this.booleanValue = value;
    }

    private int getType() {
        if (this.doubleValue != null) {
            return 1;
        }
        if (this.stringValue != null) {
            return 2;
        }
        return 3;
    }

    protected Double getDoubleValue() {
        return this.doubleValue;
    }

    protected boolean isNumeric() {
        return this.doubleValue != null;
    }

    protected CellAddress getAddress() {
        return this.address;
    }

    public String valueAsString() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        if (this.doubleValue != null) {
            return this.doubleValue.toString();
        }
        return this.booleanValue.toString();
    }
}

