/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.excel.coditional;

import com.inet.docx.document.excel.WorkbookAnalyzer;
import com.inet.docx.document.excel.coditional.CellAddressAndValue;
import com.inet.docx.document.excel.coditional.ConditionalFormatingHandler;
import com.inet.docx.document.excel.coditional.FormatingHandler;
import java.util.List;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxf;

public class AboveAverageHandler
extends FormatingHandler {
    private boolean isAboveAverage;

    protected AboveAverageHandler(int priority, ConditionalFormatingHandler formatingHandler, CTDxf format, boolean isAboveAverage) {
        super(priority, formatingHandler, format);
        this.isAboveAverage = isAboveAverage;
    }

    @Override
    protected void checkValues(List<CellAddressAndValue> cellValues, WorkbookAnalyzer.IndexSizeAndStyle[] rows, WorkbookAnalyzer.IndexSizeAndStyle[] columns) {
        double value = 0.0;
        int numericCount = 0;
        for (CellAddressAndValue nccv : cellValues) {
            if (!nccv.isNumeric()) continue;
            value += nccv.getDoubleValue().doubleValue();
            ++numericCount;
        }
        double average = value / (double)numericCount;
        for (CellAddressAndValue nccv : cellValues) {
            if (!nccv.isNumeric() || !AboveAverageHandler.isInDisplayedRange(rows, columns, nccv.getAddress())) continue;
            if (this.isAboveAverage && nccv.getDoubleValue() > average) {
                this.addAddress(nccv.getAddress());
                continue;
            }
            if (this.isAboveAverage || !(nccv.getDoubleValue() < average)) continue;
            this.addAddress(nccv.getAddress());
        }
    }
}

