/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.subelements.table;

import com.inet.docx.document.elements.DocumentElement;
import com.inet.docx.document.elements.style.CellStyle;
import com.inet.docx.document.table.TableData;
import com.inet.docx.document.utilities.Util;
import java.awt.Color;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTextDirection;

public class TableCell {
    private int startColumn;
    private int startRow;
    private int endColumn;
    private int endRow;
    private int width;
    private int height;
    private boolean exactHeight;
    private STTextDirection.Enum textDirection;
    private CellStyle style;
    private ArrayList<DocumentElement> docElements;
    private Insets margin;

    public TableCell(TableData table, int startColumn, int startRow, CellStyle style) {
        this.startColumn = this.endColumn = startColumn;
        this.startRow = this.endRow = startRow;
        this.style = style;
        this.margin = style.getMargin();
        this.margin = this.margin != null ? new Insets(Math.max(0, this.margin.top), Math.max(0, this.margin.left), Math.max(0, this.margin.bottom), Math.max(0, this.margin.right)) : new Insets(0, 0, 0, 0);
        this.docElements = new ArrayList();
    }

    public CellStyle getCellStyle() {
        return this.style;
    }

    public void setBackgroundColor(Color col) {
        this.style = this.style.clone();
        this.style.setCellBackground(col);
    }

    public void setEndColumn(int endColumn) {
        this.endColumn = endColumn;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void addElement(DocumentElement de) {
        if (this.getStartRow() != this.getEndRow() && de.isEmpty()) {
            return;
        }
        this.docElements.add(de);
    }

    public List<DocumentElement> getContent() {
        return this.docElements;
    }

    public void setHeight(int height, boolean isExactHeight) {
        this.height = height;
        this.exactHeight = isExactHeight;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isExactHeight() {
        return this.exactHeight;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public STTextDirection.Enum getTextDirection() {
        return this.textDirection;
    }

    public void setTextDirection(STTextDirection.Enum textDirection) {
        this.textDirection = textDirection;
    }

    public TableCell clone(TableData table) {
        TableCell tc = new TableCell(table, this.startColumn, this.startRow, this.style);
        tc.endRow = this.endRow;
        tc.endColumn = this.endColumn;
        tc.width = this.width;
        tc.height = this.height;
        tc.exactHeight = this.exactHeight;
        tc.docElements = Util.cloneData(this.docElements);
        return tc;
    }
}

