/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.subelements.drawing;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.elements.DocumentElement;
import com.inet.docx.document.elements.style.ShapeBodyProperties;
import com.inet.docx.document.elements.style.Spacing;
import com.inet.docx.document.elements.subelements.Positionable;
import com.inet.docx.document.paragraph.StringLayouter;
import com.inet.docx.layout.DocumentLayouter;
import com.inet.docx.view.DefaultRenderContext;
import com.inet.docx.view.PageElement;
import com.inet.docx.view.PageProperties;
import com.inet.docx.view.RenderContext;
import com.inet.docx.view.RenderPage;
import com.inet.docx.view.drawing.SimpleShape;
import com.inet.docx.view.paragraph.ParagraphRow;
import com.inet.docx.view.paragraph.ParagraphView;
import com.inet.docx.view.paragraph.RowTextPiece;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class TextBoxShape
extends SimpleShape {
    private SimpleShape simShape;
    private List<DocumentElement> sourceModel;
    private List<PageElement> textContent;

    public TextBoxShape(SimpleShape simShape, List<DocumentElement> sourceModel) {
        super(SimpleShape.ShapeType.rect.name(), new Rectangle2D.Double(0.0, 0.0, simShape.getBoundsShape().getBounds2D().getWidth(), simShape.getBoundsShape().getBounds2D().getHeight()));
        this.setBgColor(simShape.getBackgroundColor());
        this.setAutoFit(simShape.isAutoFit());
        this.simShape = simShape;
        this.sourceModel = sourceModel;
    }

    public double getContentRotation() {
        return this.getContentProperties().getContentRotation();
    }

    private List<PageElement> getTextContent(RenderContext context, AffineTransform transform) {
        if (this.textContent == null) {
            boolean isLastSection;
            this.textContent = new ArrayList<PageElement>();
            double halfOfBorderLineWidth = this.simShape.getBasicStrokeData().getBorderLineWidth() / 2.0;
            double x = this.getPosition().getX() + halfOfBorderLineWidth;
            double y = this.getPosition().getY() + halfOfBorderLineWidth;
            PageProperties pageLayout = context.getPageLayout();
            double width = this.getWidth() == 0.0 ? (double)(pageLayout.getPageWidth() - pageLayout.getMarginLeft() - pageLayout.getMarginRight()) : this.getWidth();
            width -= halfOfBorderLineWidth;
            ShapeBodyProperties contentProperties = this.simShape.getContentProperties();
            if (contentProperties != null) {
                x += (double)contentProperties.getLeftMargin();
                y += (double)contentProperties.getTopMargin();
                if (!contentProperties.isTextWrap()) {
                    double endXPositionPage = (double)(pageLayout.getPageWidth() - pageLayout.getMarginRight()) - halfOfBorderLineWidth;
                    if (this.getPosition().getX() + this.getWidth() < endXPositionPage) {
                        width = endXPositionPage - this.getPosition().getX() - (double)pageLayout.getMarginLeft() - halfOfBorderLineWidth;
                    }
                }
            }
            Insets pageInsets = new Insets((int)y, (int)x, 0, 0);
            PageProperties props = new PageProperties((int)width, Integer.MAX_VALUE, pageInsets);
            List<RenderPage> pages = DocumentLayouter.layoutElements(this.sourceModel, null, null, context = new DefaultRenderContext(context.getDocumentProperties(), props, context, RenderContext.CONTEXT_TYPE.textBox), isLastSection = !this.simShape.isAutoFit());
            if (pages.size() >= 1) {
                this.textContent.addAll(pages.get(0).getAllElements());
            }
            this.modifySizeIfNeeded(context.getDocumentProperties());
        }
        return this.textContent;
    }

    private void modifySizeIfNeeded(DocumentProperties docProperties) {
        double shapeWidth = this.simShape.getWidth();
        double shapeHeight = this.simShape.getHeight();
        Point2D position = this.simShape.getPosition();
        ShapeBodyProperties contentProperties = this.simShape.getContentProperties();
        if (this.simShape.isAutoFit()) {
            if (!this.textContent.isEmpty()) {
                PageElement lastElement = this.textContent.get(this.textContent.size() - 1);
                Rectangle2D bounds = lastElement.getBounds();
                shapeHeight = bounds.getY() + bounds.getHeight() + (double)lastElement.getSpacingBottom();
                shapeHeight += this.simShape.getBasicStrokeData().getBorderLineWidth() / 2.0;
            } else {
                StringLayouter layouter = docProperties.getLayouter(docProperties.getDefaultRenderFont());
                shapeHeight = layouter.getFontDimensions().getRowHeight();
                Spacing spacing = docProperties.getDefaultSpacing();
                shapeHeight += (double)(spacing.getBefore() + spacing.getAfter());
                shapeHeight += this.simShape.getBasicStrokeData().getBorderLineWidth();
                shapeHeight = contentProperties != null ? (shapeHeight += (double)contentProperties.getTopMargin()) : (shapeHeight += 72.0);
            }
            shapeHeight = contentProperties != null ? (shapeHeight += (double)contentProperties.getBottomMargin()) : (shapeHeight += 72.0);
        }
        if (contentProperties != null && !contentProperties.isTextWrap()) {
            shapeWidth = 0.0;
            for (PageElement element : this.textContent) {
                shapeWidth = Math.max(shapeWidth, this.calcWidth(element));
            }
            if (shapeWidth == 0.0) {
                shapeWidth = this.calcWidthOfEmptyTextBoxBasedOnFont(docProperties);
            }
            shapeWidth += (double)(contentProperties.getLeftMargin() + contentProperties.getRightMargin());
            shapeWidth += this.simShape.getBasicStrokeData().getBorderLineWidth();
        }
        this.simShape.modifySize(position.getX(), position.getY(), shapeWidth, shapeHeight);
    }

    private double calcWidth(PageElement element) {
        double elementWidth = element.getBounds().getWidth();
        if (element instanceof ParagraphView) {
            ParagraphView pView = (ParagraphView)element;
            double paragraphWidth = 0.0;
            for (int index = 0; index < pView.getRowCount(); ++index) {
                ParagraphRow row = pView.getRow(index);
                paragraphWidth = Math.max(paragraphWidth, this.calcWidth(row));
            }
            elementWidth = Math.min(elementWidth, paragraphWidth);
        }
        return elementWidth;
    }

    private double calcWidth(ParagraphRow row) {
        double width = 0.0;
        for (int posIndex = 0; posIndex < row.getElementCount(); ++posIndex) {
            Positionable positionable = row.getElement(posIndex);
            width += positionable.getWidth();
        }
        return width;
    }

    private double calcWidthOfEmptyTextBoxBasedOnFont(DocumentProperties docProperties) {
        double shapeWidth = -1.0;
        String text = "A";
        for (PageElement element : this.textContent) {
            if (!(element instanceof ParagraphView)) continue;
            ParagraphView pView = (ParagraphView)element;
            double paragraphWidth = 0.0;
            for (int index = 0; index < pView.getRowCount(); ++index) {
                ParagraphRow row = pView.getRow(index);
                double rowWidth = 0.0;
                for (int posIndex = 0; posIndex < row.getElementCount(); ++posIndex) {
                    Positionable positionable = row.getElement(posIndex);
                    if (!(positionable instanceof RowTextPiece)) continue;
                    RowTextPiece piece = (RowTextPiece)positionable;
                    StringLayouter layouter = docProperties.getLayouter(piece.getParent().getRenderFont());
                    rowWidth += layouter.getTextLength(text);
                }
                paragraphWidth = Math.max(paragraphWidth, rowWidth);
            }
            shapeWidth = Math.max(shapeWidth, paragraphWidth);
        }
        if (shapeWidth == -1.0) {
            StringLayouter layouter = docProperties.getLayouter(docProperties.getDefaultRenderFont());
            return layouter.getTextLength(text);
        }
        return shapeWidth;
    }

    public List<Positionable> getElements(RenderContext context, AffineTransform transform) {
        ArrayList<Positionable> elements = new ArrayList<Positionable>();
        this.getTextContent(context, transform).forEach(e -> e.collectElements(elements));
        return elements;
    }

    @Override
    public Shape getBoundsShape() {
        Rectangle2D.Double shape = new Rectangle2D.Double(this.getPosition().getX(), this.getPosition().getY(), this.getWidth(), this.getHeight());
        if (this.simShape.getContentProperties() == null || !this.simShape.getContentProperties().isTextWrap()) {
            // empty if block
        }
        return this.getTransformation().createTransformedShape(shape);
    }

    @Override
    public double getWidth() {
        return this.simShape.getWidth();
    }

    @Override
    public void setWidth(double width) {
        super.setWidth(width);
        this.simShape.setWidth(width);
    }

    public SimpleShape getSimShape() {
        return this.simShape;
    }

    @Override
    public double getHeight() {
        return this.simShape.getHeight();
    }

    @Override
    public void setHeight(double height) {
        super.setHeight(height);
        this.simShape.setHeight(height);
    }

    @Override
    public Point2D getPosition() {
        return this.simShape.getPosition();
    }

    @Override
    public double getScaleX() {
        return this.simShape.getScaleX();
    }

    @Override
    public double getScaleY() {
        return this.simShape.getScaleY();
    }

    @Override
    public double getRotation() {
        return this.simShape.getRotation();
    }
}

