/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.subelements.drawing;

import com.inet.docx.document.utilities.UnitNumber;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.PageProperties;

public class DimensionDefinition {
    private RelativeType type;
    private boolean horizontal;
    private UnitNumber unit;

    public DimensionDefinition(UnitNumber value, RelativeType type, boolean horizontal) {
        this.type = type;
        this.horizontal = horizontal;
        this.unit = value;
    }

    public DimensionDefinition(UnitNumber value, String type, boolean horizontal) {
        this(value, RelativeType.valueOf(type), horizontal);
    }

    public DimensionDefinition(UnitNumber value) {
        this(value, RelativeType.none, true);
    }

    @Deprecated
    private DimensionDefinition(double value, RelativeType type, boolean horizontal) {
        this.type = type;
        this.horizontal = horizontal;
        this.unit = new UnitNumber(value);
    }

    @Deprecated
    public DimensionDefinition(double value) {
        this(value, RelativeType.none, true);
    }

    public double getValue() {
        return this.unit.getAsTwips();
    }

    public UnitNumber getValueWithUnit() {
        return this.unit;
    }

    public RelativeType getRelativeType() {
        return this.type;
    }

    public double calculateValue(PageProperties pageProps, boolean oddPage) {
        double relativeSize;
        switch (this.getRelativeType()) {
            case page: {
                relativeSize = this.horizontal ? (double)pageProps.getPageWidth() : (double)pageProps.getPageHeight();
                break;
            }
            case margin: {
                if (this.horizontal) {
                    relativeSize = pageProps.getPageWidth() - pageProps.getMarginLeft() - pageProps.getMarginRight();
                    break;
                }
                relativeSize = pageProps.getPageHeight() - pageProps.getMarginTopIgnoringHeader() - pageProps.getMarginBottomIgnoringFooter();
                break;
            }
            case bottomMargin: {
                relativeSize = pageProps.getMarginBottomIgnoringFooter();
                break;
            }
            case topMargin: {
                relativeSize = pageProps.getMarginTopIgnoringHeader();
                break;
            }
            case leftMargin: {
                relativeSize = pageProps.getMarginLeft();
                break;
            }
            case rightMargin: {
                relativeSize = pageProps.getMarginRight();
                break;
            }
            case outsideMargin: {
                if (this.horizontal) {
                    relativeSize = !oddPage ? (double)pageProps.getMarginLeft() : (double)pageProps.getMarginRight();
                    break;
                }
                relativeSize = oddPage ? (double)pageProps.getMarginTopIgnoringHeader() : (double)pageProps.getMarginBottomIgnoringFooter();
                break;
            }
            case insideMargin: {
                if (this.horizontal) {
                    relativeSize = oddPage ? (double)pageProps.getMarginLeft() : (double)pageProps.getMarginRight();
                    break;
                }
                relativeSize = oddPage ? (double)pageProps.getMarginTopIgnoringHeader() : (double)pageProps.getMarginBottomIgnoringFooter();
                break;
            }
            case none: {
                return this.getValue();
            }
            default: {
                relativeSize = this.getValue();
                Util.LOGGER.error((Object)("Unknown " + String.valueOf((Object)this.getRelativeType()) + " percentage size reference!"));
            }
        }
        return relativeSize * this.getValue();
    }

    public String toString() {
        return String.valueOf((Object)this.type) + " " + this.horizontal + " " + this.getValue();
    }

    public static enum RelativeType {
        insideMargin,
        outsideMargin,
        leftMargin,
        rightMargin,
        topMargin,
        bottomMargin,
        margin,
        page,
        none;

    }
}

