/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.subelements;

import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.subelements.ParagraphElement;
import com.inet.docx.document.elements.subelements.TextRowElement;
import java.awt.Color;
import javax.annotation.Nonnull;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STPTabAlignment;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STPTabLeader;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STPTabRelativeTo;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTabJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTabTlc;

public class Tab
implements ParagraphElement {
    private STTabJc.Enum style;
    private STTabTlc.Enum leader;
    private int pos;
    private STPTabAlignment.Enum align;
    private STPTabLeader.Enum pLeader;
    private STPTabRelativeTo.Enum relativ;
    private TextRowElement placeholder;
    private RenderFont renderFont;

    public Tab(int pos) {
        this.style = STTabJc.Enum.forInt((int)2);
        this.leader = STTabTlc.Enum.forInt((int)1);
        this.pos = pos;
    }

    public Tab(STTabJc.Enum style, STTabTlc.Enum leader, int pos) {
        this.style = style;
        this.leader = leader;
        this.pos = pos;
    }

    public Tab(STPTabAlignment.Enum align, STPTabLeader.Enum leader, STPTabRelativeTo.Enum relativ) {
        this.align = align;
        this.pLeader = leader;
        this.relativ = relativ;
    }

    @Override
    public RenderFont getRenderFont() {
        return this.renderFont != null ? this.renderFont : (this.placeholder != null ? this.placeholder.getRenderFont() : null);
    }

    public void setRenderFont(@Nonnull RenderFont renderFont) {
        this.renderFont = renderFont;
    }

    @Override
    public ParagraphElement.ParagraphElementType getElementType() {
        return ParagraphElement.ParagraphElementType.Tab;
    }

    @Override
    public boolean isAnchored() {
        return false;
    }

    public String toString() {
        return String.valueOf(this.style) + " " + String.valueOf(this.leader) + " " + this.pos;
    }

    public int getPosition() {
        return this.pos;
    }

    public STTabJc.Enum getTabStyle() {
        return this.style;
    }

    public STTabTlc.Enum getLeader() {
        return this.leader;
    }

    public STPTabAlignment.Enum getTabAlign() {
        return this.align;
    }

    public ParagraphElement clone() {
        Tab tab = new Tab(this.style, this.leader, this.pos);
        tab.align = this.align;
        tab.pLeader = this.pLeader;
        tab.relativ = this.relativ;
        tab.renderFont = this.renderFont;
        return tab;
    }

    public void setRenderData(@Nonnull RenderFont renderFont, @Nonnull Color color, @Nonnull Color bgColor) {
        this.renderFont = renderFont;
        String text = "          ";
        if (this.leader == STTabTlc.DOT) {
            text = "..........";
        } else if (this.leader == STTabTlc.MIDDLE_DOT) {
            text = "\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7";
        } else if (this.leader == STTabTlc.HYPHEN) {
            text = "----------";
        } else if (this.leader == STTabTlc.UNDERSCORE) {
            text = "__________";
        }
        this.placeholder = new TextRowElement(text, renderFont, color, bgColor);
    }

    public TextRowElement getPlaceholder() {
        return this.placeholder;
    }

    public TextRowElement getPlaceholder(@Nonnull RenderFont renderFont, @Nonnull Color color, @Nonnull Color bgColor) {
        this.setRenderData(renderFont, color, bgColor);
        return this.placeholder;
    }
}

