/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.subelements;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.elements.style.LineProperties;
import com.inet.docx.document.elements.style.NumberingLevel;
import com.inet.docx.document.elements.style.ParagraphAndRunStyle;
import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.style.RunRenderInformations;
import com.inet.docx.document.utilities.Util;
import java.awt.Color;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STNumberFormat;

public class NumberingInfo {
    private String displayText;
    private NumberingLevel numberingLevel;
    private RenderFont renderFont;
    private RunRenderInformations renderInfos;
    private Color autoColor = null;

    public NumberingInfo(DocumentProperties documentProperties, int key, int lvlValue, RunRenderInformations ri) {
        this.numberingLevel = documentProperties.getNumberingLevel(key, lvlValue);
        ParagraphAndRunStyle sf = this.numberingLevel.getStyleFont();
        if (sf != null && sf.getTextRenderInformations() != null) {
            if (ri != null) {
                this.renderInfos = RunRenderInformations.mergeRenderInformations(sf, ri);
                if (STNumberFormat.BULLET.equals(this.numberingLevel.getDisplayFormat()) && sf.getFontName() != null) {
                    RunRenderInformations.resetFontName(this.renderInfos, sf.getFontName());
                }
            } else {
                this.renderInfos = sf.getTextRenderInformations();
            }
        } else if (this.renderInfos == null) {
            this.renderInfos = ri;
        }
        int fontStyle = 0;
        if (this.renderInfos.getBold() != null && this.renderInfos.getBold().booleanValue()) {
            fontStyle = 1;
        }
        if (this.renderInfos.getItalic() != null && this.renderInfos.getItalic().booleanValue()) {
            fontStyle = 2;
        }
        LineProperties underline = this.renderInfos.getUnderline();
        boolean strikethrough = this.renderInfos.getStrikethrough() != null ? this.renderInfos.getStrikethrough() : false;
        boolean invisible = this.renderInfos.getVanish() != null ? this.renderInfos.getVanish() : false;
        boolean smallCaps = this.renderInfos.getSmallCaps() != null ? this.renderInfos.getSmallCaps() : false;
        float spacing = this.renderInfos.getFontSpacing() != null ? this.renderInfos.getFontSpacing().floatValue() : 0.0f;
        Float flt = documentProperties.getStandardStyleFont().getFontSize() != null ? documentProperties.getStandardStyleFont().getFontSize() : documentProperties.getDefaultStyleFont().getFontSize();
        float size = this.renderInfos.getFontSize() != null ? this.renderInfos.getFontSize().floatValue() : flt.floatValue();
        float textScale = this.renderInfos.getTextScale() != null ? this.renderInfos.getTextScale().floatValue() : 1.0f;
        int verticalOffset = this.renderInfos.getVerticalPosition() != null ? this.renderInfos.getVerticalPosition() : 0;
        String fontName = this.renderInfos.getFontName() != null ? this.renderInfos.getFontName() : documentProperties.getDefaultRenderFont().getFontName();
        this.renderFont = new RenderFont(fontName, size, fontStyle, underline, strikethrough, invisible, smallCaps, spacing, textScale, verticalOffset);
        documentProperties.getLayouter(this.renderFont);
    }

    public void setDisplayText(DocumentProperties documentProperties) {
        this.numberingLevel.getCurrentValue(true);
        String text = NumberingLevel.handleNumberingDisplaxText(this.numberingLevel.getDisplayValue(), documentProperties, this.numberingLevel.getKey(), this.numberingLevel.getLevel());
        this.displayText = Util.translateSymbolFontCharacters(text, this.renderFont);
    }

    public void resetCount() {
        this.numberingLevel.resetCount();
    }

    public Color getFontColor() {
        return this.autoColor != null ? this.autoColor : this.renderInfos.getFontColor();
    }

    public void setAutoColor(Color autoColor) {
        this.autoColor = autoColor;
    }

    public Color getBgColor() {
        return this.renderInfos.getFontBackgroundColor();
    }

    public RenderFont getFont() {
        return this.renderFont;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public STJc.Enum getJustification() {
        return this.numberingLevel.getJustification();
    }

    public NumberingLevel getNumberingLevel() {
        return this.numberingLevel;
    }
}

