/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.subelements;

import com.inet.docx.document.DocumentProperties;
import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.style.RunRenderInformations;
import com.inet.docx.document.elements.subelements.TextRowElement;
import com.inet.docx.document.paragraph.ParagraphData;
import com.inet.docx.document.utilities.Util;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.officeDocument.x2006.math.CTOMath;
import org.openxmlformats.schemas.officeDocument.x2006.math.CTOMathArg;
import org.openxmlformats.schemas.officeDocument.x2006.math.CTOMathPara;
import org.openxmlformats.schemas.officeDocument.x2006.math.CTR;
import org.openxmlformats.schemas.officeDocument.x2006.math.CTRPR;
import org.openxmlformats.schemas.officeDocument.x2006.math.CTSSub;
import org.openxmlformats.schemas.officeDocument.x2006.math.CTSSup;
import org.openxmlformats.schemas.officeDocument.x2006.math.CTText;
import org.openxmlformats.schemas.officeDocument.x2006.math.impl.CTDImpl;
import org.openxmlformats.schemas.officeDocument.x2006.math.impl.CTFImpl;
import org.openxmlformats.schemas.officeDocument.x2006.math.impl.CTNaryImpl;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STVerticalAlignRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;

public class MathematicalFunction {
    private List<TextRowElement> baseLineElements;
    private int unhandledCount;

    public MathematicalFunction(CTOMathPara functionDef, DocumentProperties documentProperties) {
        Util.LOGGER.error((Object)"Not implemented \"CTOMathPara\" object!");
        this.unhandledCount = -1;
    }

    public MathematicalFunction(CTOMath functionDef, DocumentProperties documentProperties) {
        this.baseLineElements = new ArrayList<TextRowElement>();
        XmlCursor cursor = functionDef.newCursor();
        cursor.selectPath("./*");
        this.unhandledCount = cursor.getSelectionCount();
        while (cursor.toNextSelection()) {
            XmlObject partObj = cursor.getObject();
            if (partObj instanceof CTFImpl) continue;
            if (partObj instanceof CTR) {
                this.baseLineElements.add(this.convert((CTR)partObj, documentProperties, null));
                --this.unhandledCount;
                continue;
            }
            if (partObj instanceof CTSSup) {
                this.baseLineElements.addAll(this.convert((CTSSup)partObj, documentProperties));
                --this.unhandledCount;
                continue;
            }
            if (partObj instanceof CTSSub) {
                this.baseLineElements.addAll(this.convert((CTSSub)partObj, documentProperties));
                --this.unhandledCount;
                continue;
            }
            if (partObj instanceof CTNaryImpl || partObj instanceof CTDImpl) continue;
            Util.LOGGER.error((Object)("OMath unhandled \"" + partObj.getClass().getName() + "\" object!"));
        }
        cursor.dispose();
        if (this.unhandledCount != 0) {
            Util.LOGGER.error((Object)("Not implemented \"CTOMath\" objects " + this.unhandledCount + "!"));
        }
    }

    public boolean canHandle() {
        return this.unhandledCount == 0;
    }

    public void handleContent(ParagraphData pa) {
        for (TextRowElement tre : this.baseLineElements) {
            pa.addElement(tre);
        }
    }

    private List<TextRowElement> convert(CTSSub sub, DocumentProperties docProps) {
        RunRenderInformations rri = RunRenderInformations.getRenderInformations(sub.getSSubPr().getCtrlPr().getRPr(), docProps);
        CTOMathArg baseArg = sub.getE();
        ArrayList<TextRowElement> elements = new ArrayList<TextRowElement>();
        for (CTR ctr : baseArg.getRList()) {
            elements.add(this.convert(ctr, docProps, rri));
        }
        CTOMathArg expArg = sub.getSub();
        for (CTR ctr : expArg.getRList()) {
            TextRowElement tre = this.convert(ctr, docProps, rri);
            tre.getRenderFont().setVerticalAlign(STVerticalAlignRun.SUBSCRIPT);
            elements.add(tre);
        }
        return elements;
    }

    private List<TextRowElement> convert(CTSSup sup, DocumentProperties docProps) {
        RunRenderInformations rri = RunRenderInformations.getRenderInformations(sup.getSSupPr().getCtrlPr().getRPr(), docProps);
        CTOMathArg baseArg = sup.getE();
        ArrayList<TextRowElement> elements = new ArrayList<TextRowElement>();
        for (CTR ctr : baseArg.getRList()) {
            elements.add(this.convert(ctr, docProps, rri));
        }
        CTOMathArg expArg = sup.getSup();
        for (CTR ctr : expArg.getRList()) {
            TextRowElement tre = this.convert(ctr, docProps, rri);
            tre.getRenderFont().setVerticalAlign(STVerticalAlignRun.SUPERSCRIPT);
            elements.add(tre);
        }
        return elements;
    }

    private TextRowElement convert(CTR ctr, DocumentProperties docProps, RunRenderInformations baseFormat) {
        StringBuilder buf = new StringBuilder();
        RunRenderInformations rri = null;
        XmlCursor runCursor = ctr.newCursor();
        runCursor.selectPath("./*");
        while (runCursor.toNextSelection()) {
            XmlObject runObj = runCursor.getObject();
            if (runObj instanceof CTRPR) continue;
            if (runObj instanceof CTRPr) {
                rri = RunRenderInformations.getRenderInformations((CTRPr)runObj, docProps);
                if (baseFormat == null) continue;
                rri = RunRenderInformations.mergeRenderInformations(rri, baseFormat);
                continue;
            }
            if (runObj instanceof CTText) {
                String str = ((CTText)runObj).getStringValue();
                if (str.indexOf(61) > -1) {
                    str = str.replaceAll("=", " = ");
                }
                buf.append(str);
                continue;
            }
            Util.LOGGER.error((Object)("OMath ctr unhandled \"" + runObj.getClass().getName() + "\" object!"));
        }
        RenderFont rf = rri.createFont(docProps);
        return new TextRowElement(buf.toString(), rf, rri.getFontColor(), rri.getFontBackgroundColor());
    }
}

