/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.subelements;

import com.inet.docx.document.elements.style.RenderFont;
import com.inet.docx.document.elements.subelements.ParagraphElement;
import com.inet.docx.document.utilities.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFFCheckBox;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFFDDList;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFFData;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFldChar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;

public class FieldPart
implements ParagraphElement {
    private FormFieldType fieldType = FormFieldType.none;
    private STFldCharType.Enum typeMarker;
    private RenderFont renderFont;
    private Map<FormFieldAttribute, Object> formFieldAttributes;

    public FieldPart(CTFldChar fldCar, RenderFont renderFont) {
        CTFFData ffData;
        this.typeMarker = fldCar.getFldCharType();
        this.renderFont = renderFont;
        if (STFldCharType.BEGIN == this.typeMarker && (ffData = fldCar.getFfData()) != null) {
            this.formFieldAttributes = new HashMap<FormFieldAttribute, Object>();
            List cbList = ffData.getCheckBoxList();
            if (cbList.size() > 0) {
                this.fieldType = FormFieldType.checkBox;
                CTFFCheckBox cb0 = (CTFFCheckBox)cbList.get(0);
                this.formFieldAttributes.put(FormFieldAttribute.checkBoxValue, Util.getBooleanForOnOff(cb0.getChecked(), true));
                this.formFieldAttributes.put(FormFieldAttribute.checkBoxAutoSize, cb0.isSetSizeAuto() && cb0.getSizeAuto().getVal() == null ? Boolean.TRUE : Util.getBooleanForOnOff(cb0.getSizeAuto(), true));
                if (!Boolean.TRUE.equals(this.formFieldAttributes.get((Object)FormFieldAttribute.checkBoxAutoSize))) {
                    this.formFieldAttributes.put(FormFieldAttribute.checkBoxSize, cb0.getSize().getVal());
                }
                return;
            }
            List ddl = ffData.getDdListList();
            if (ddl.size() > 0) {
                this.fieldType = FormFieldType.dropDown;
                CTFFDDList dropDown = (CTFFDDList)ddl.get(0);
                CTDecimalNumber num = dropDown.getResult();
                int selection = num != null ? dropDown.getResult().getVal().intValue() : 0;
                this.formFieldAttributes.put(FormFieldAttribute.dropDownSelection, dropDown.getListEntryArray(selection).getVal());
            }
        }
    }

    public Object getAttributeValue(FormFieldAttribute attribute) {
        if (this.formFieldAttributes != null) {
            return this.formFieldAttributes.get((Object)attribute);
        }
        return null;
    }

    @Override
    public RenderFont getRenderFont() {
        return this.renderFont;
    }

    public STFldCharType.Enum getTypeMarker() {
        return this.typeMarker;
    }

    protected FormFieldType getFormFieldType() {
        return this.fieldType;
    }

    @Override
    public ParagraphElement.ParagraphElementType getElementType() {
        return null;
    }

    public ParagraphElement clone() {
        return this;
    }

    @Override
    public boolean isAnchored() {
        return false;
    }

    public static enum FormFieldType {
        checkBox,
        dropDown,
        none;

    }

    public static enum FormFieldAttribute {
        checkBoxAutoSize,
        checkBoxSize,
        checkBoxValue,
        dropDownSelection;

    }
}

