/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.style;

import com.inet.docx.document.elements.style.LineProperties;
import com.inet.docx.document.paragraph.FontDimensionsTwips;
import java.util.Objects;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STVerticalAlignRun;

public class RenderFont {
    private String fontName;
    private float fontSize;
    private int fontStyle;
    private LineProperties underline;
    private boolean strikethrough;
    private boolean invisible;
    private boolean smallCaps;
    private STVerticalAlignRun.Enum verticalAlign = STVerticalAlignRun.BASELINE;
    private FontDimensionsTwips fontDimensions;
    private double spacing;
    private double textScale;
    private int verticalOffset;

    public RenderFont(String fontName, float fontSize, int fontStyle, LineProperties underline, boolean strikethrough, boolean invisible, boolean smallCaps, double spacing, double textScale, int verticalOffset) {
        this.fontName = fontName;
        this.fontSize = fontSize;
        this.fontStyle = fontStyle;
        this.underline = underline;
        this.strikethrough = strikethrough;
        this.spacing = spacing;
        this.textScale = textScale;
        this.verticalOffset = verticalOffset;
    }

    public LineProperties getUnderline() {
        return this.underline;
    }

    public boolean isStrikethrough() {
        return this.strikethrough;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public boolean isSmallCaps() {
        return this.smallCaps;
    }

    public void setRenderDimensions(FontDimensionsTwips fontDimensions) {
        this.fontDimensions = fontDimensions;
    }

    public FontDimensionsTwips getRenderDimensions() {
        return this.fontDimensions;
    }

    public String toString() {
        return this.fontName + " " + this.fontSize + " " + this.fontStyle + " " + String.valueOf(this.verticalAlign) + " " + String.valueOf(this.underline) + " " + this.invisible + " " + this.smallCaps + " " + this.spacing + " " + this.textScale + " " + this.verticalOffset;
    }

    public String getFontName() {
        return this.fontName;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public STVerticalAlignRun.Enum getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setVerticalAlign(STVerticalAlignRun.Enum verticalAlign) {
        this.verticalAlign = verticalAlign;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenderFont that = (RenderFont)o;
        return Float.compare(that.fontSize, this.fontSize) == 0 && this.fontStyle == that.fontStyle && this.underline == that.underline && this.invisible == that.invisible && this.smallCaps == that.smallCaps && this.textScale == that.textScale && this.verticalOffset == that.verticalOffset && this.strikethrough == that.strikethrough && Objects.equals(this.fontName, that.fontName) && Objects.equals(this.verticalAlign, that.verticalAlign) && Objects.equals(this.fontDimensions, that.fontDimensions);
    }

    public double getSpacingValue() {
        return this.spacing;
    }

    public double getSpacing() {
        return this.spacing / (20.0 * (double)this.fontSize);
    }

    public double getTextScale() {
        return this.textScale;
    }

    public int getVerticalOffset() {
        return this.verticalOffset;
    }

    public RenderFont clone() {
        RenderFont theClone = new RenderFont(this.fontName, this.fontSize, this.fontStyle, this.underline, this.strikethrough, this.invisible, this.smallCaps, this.spacing, this.textScale, this.verticalOffset);
        theClone.fontDimensions = this.fontDimensions;
        theClone.verticalAlign = this.verticalAlign;
        return theClone;
    }
}

