/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.style;

import com.inet.docx.document.elements.style.LineStyle;
import java.awt.Color;
import java.util.Objects;

public class LineProperties {
    public static final LineProperties EMPTY_LINE = new LineProperties(null, LineStyle.NONE, false, 0, 0.0);
    private int width;
    private double space;
    private LineStyle lineStyle;
    private Color color;
    private boolean heavy;

    public LineProperties(Color color, String lineStyle, int width, double space) {
        this(color, LineStyle.getStyle(lineStyle), lineStyle != null && lineStyle.toLowerCase().contains("heavy"), width, space);
    }

    public LineProperties(Color color, LineStyle lineStyle, boolean heavy, int width, double space) {
        this.color = color;
        this.lineStyle = lineStyle;
        this.heavy = heavy || lineStyle == LineStyle.THICK;
        this.width = width;
        this.space = space;
    }

    public boolean isLineStyle(LineStyle testStyle) {
        return testStyle == this.lineStyle;
    }

    public LineStyle getStyle() {
        return this.lineStyle;
    }

    public int getWidth() {
        return this.width;
    }

    public double getSpace() {
        return this.space;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isHeavy() {
        return this.heavy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineProperties that = (LineProperties)o;
        return this.width == that.width && this.heavy == that.heavy && this.lineStyle == that.lineStyle && Objects.equals(this.color, that.color);
    }

    public int hashCode() {
        return Objects.hash(this.width, this.lineStyle, this.color, this.heavy);
    }

    public String toString() {
        return String.valueOf(this.lineStyle) + " " + this.width + " " + String.valueOf(this.color) + " " + this.space;
    }
}

