/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.style;

import com.inet.docx.document.elements.style.CellBorder;
import com.inet.docx.document.elements.style.ParagraphAndRunStyle;
import com.inet.docx.document.elements.style.StyleTable;
import java.awt.Color;
import java.awt.Insets;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalJc;

public class CellStyle {
    private StyleTable tableStyle;
    private ParagraphAndRunStyle cellFont;
    private Color cellBackground;
    private CellBorder border;
    private Insets margin;
    private STVerticalJc.Enum verticalAlign;
    private boolean textWraping = true;
    private boolean canGrowVertical = true;
    private boolean canGrowHorizontal = false;

    public CellStyle(ParagraphAndRunStyle cellFont, StyleTable tableStyle) {
        this.cellFont = cellFont;
        this.tableStyle = tableStyle;
    }

    protected void setTableStyle(StyleTable tableStyle) {
        this.tableStyle = tableStyle;
    }

    public ParagraphAndRunStyle getFontStyle() {
        return this.cellFont;
    }

    public void setFontStyle(ParagraphAndRunStyle cellFont) {
        this.cellFont = cellFont;
    }

    public Color getCellBackground() {
        if (this.cellBackground == null && this.tableStyle != null) {
            return this.tableStyle.getCellDefaultBackground();
        }
        return this.cellBackground;
    }

    public void setCellBackground(Color cellBackground) {
        this.cellBackground = cellBackground;
    }

    public CellBorder getBorder() {
        if (this.border == null && this.tableStyle == null) {
            return CellBorder.NO_BORDER;
        }
        if (this.border == null && this.tableStyle != null) {
            return this.tableStyle.getCellDefaultBorder();
        }
        return this.border;
    }

    public void setBorder(CellBorder border) {
        this.border = border;
    }

    public STVerticalJc.Enum getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setVerticalAlign(STVerticalJc.Enum verticalAlign) {
        this.verticalAlign = verticalAlign;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
    }

    public boolean isTextWraping() {
        return this.textWraping;
    }

    public void setTextWraping(boolean textWraping) {
        this.textWraping = textWraping;
        this.canGrowHorizontal = !textWraping;
    }

    public boolean isCanGrowVertical() {
        return this.canGrowVertical;
    }

    public void setCanGrowVertical(boolean canGrowVertical) {
        this.canGrowVertical = canGrowVertical;
    }

    public boolean isCanGrowHorizontal() {
        return this.canGrowHorizontal;
    }

    public void setCanGrowHorizontal(boolean canGrowHorizontal) {
        this.canGrowHorizontal = canGrowHorizontal;
        this.textWraping = !canGrowHorizontal;
    }

    public CellStyle clone() {
        CellStyle copy = new CellStyle(this.cellFont != null ? this.cellFont.clone() : null, this.tableStyle);
        copy.cellBackground = this.cellBackground;
        copy.margin = this.margin;
        copy.border = this.border;
        copy.verticalAlign = this.verticalAlign;
        return copy;
    }

    public static CellStyle merge(CellStyle primaryStyle, CellStyle secondaryStyle) {
        if (secondaryStyle == null) {
            return primaryStyle;
        }
        if (primaryStyle == null) {
            return secondaryStyle;
        }
        ParagraphAndRunStyle cellFont = primaryStyle.getFontStyle() == null ? secondaryStyle.getFontStyle() : (secondaryStyle.getFontStyle() == null ? primaryStyle.getFontStyle() : ParagraphAndRunStyle.mergeStyles(primaryStyle.getFontStyle(), secondaryStyle.getFontStyle()));
        CellStyle mergedStyle = new CellStyle(cellFont, primaryStyle.tableStyle);
        mergedStyle.cellBackground = primaryStyle.cellBackground != null ? primaryStyle.cellBackground : (secondaryStyle.cellBackground != null ? secondaryStyle.cellBackground : primaryStyle.getCellBackground());
        mergedStyle.border = CellBorder.merge(primaryStyle.border, secondaryStyle.border);
        mergedStyle.margin = primaryStyle.getMargin() != null ? primaryStyle.getMargin() : secondaryStyle.getMargin();
        mergedStyle.verticalAlign = primaryStyle.getVerticalAlign() != null ? primaryStyle.getVerticalAlign() : secondaryStyle.getVerticalAlign();
        return mergedStyle;
    }
}

