/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements.style;

import com.inet.docx.document.elements.style.LineProperties;
import com.inet.docx.document.elements.subelements.BorderLines;
import com.inet.docx.document.elements.subelements.table.TableBorder;
import com.inet.docx.document.utilities.Util;
import java.awt.Color;
import java.util.HashMap;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcBorders;

public class CellBorder
extends BorderLines {
    public static final CellBorder NO_BORDER = new CellBorder(LineProperties.EMPTY_LINE);
    private LineProperties topLeft2BottomRightLine;
    private LineProperties topRight2BottomLeftLine;

    protected CellBorder(TableBorder tableBorder) {
        this.setTopLine(tableBorder.getInsideHorizontal());
        this.setLeftLine(tableBorder.getInsideVertical());
        this.setRightLine(tableBorder.getInsideVertical());
        this.setBottomLine(tableBorder.getInsideHorizontal());
    }

    protected CellBorder(CTTcBorders cellBorders, HashMap<String, Color> themeColors) {
        this.setTopLeft2BottomRightLine(Util.getLinePropertiesFromBorder(cellBorders.getTl2Br(), themeColors));
        this.setTopRight2BottomLeftLine(Util.getLinePropertiesFromBorder(cellBorders.getTr2Bl(), themeColors));
        this.setLeftLine(Util.getLinePropertiesFromBorder(cellBorders.getLeft(), themeColors));
        this.setRightLine(Util.getLinePropertiesFromBorder(cellBorders.getRight(), themeColors));
        this.setTopLine(Util.getLinePropertiesFromBorder(cellBorders.getTop(), themeColors));
        this.setBottomLine(Util.getLinePropertiesFromBorder(cellBorders.getBottom(), themeColors));
    }

    public CellBorder(LineProperties topLine, LineProperties leftLine, LineProperties bottomLine, LineProperties rightLine) {
        this.setLeftLine(leftLine);
        this.setRightLine(rightLine);
        this.setTopLine(topLine);
        this.setBottomLine(bottomLine);
    }

    public CellBorder(CellBorder defaultBorder, CTTcBorders cellBorders, HashMap<String, Color> themeColors) {
        this(cellBorders, themeColors);
        if (defaultBorder != null) {
            if (this.getTopLine() == null) {
                this.setTopLine(defaultBorder.getTopLine());
            }
            if (this.getLeftLine() == null) {
                this.setLeftLine(defaultBorder.getLeftLine());
            }
            if (this.getBottomLine() == null) {
                this.setBottomLine(defaultBorder.getBottomLine());
            }
            if (this.getRightLine() == null) {
                this.setRightLine(defaultBorder.getRightLine());
            }
            if (this.getTopRight2BottomLeftLine() == null) {
                this.setTopRight2BottomLeftLine(defaultBorder.getTopRight2BottomLeftLine());
            }
            if (this.getTopLeft2BottomRightLine() == null) {
                this.setTopLeft2BottomRightLine(defaultBorder.getTopLeft2BottomRightLine());
            }
        }
    }

    protected CellBorder(LineProperties line) {
        this.setTopLine(line);
        this.setLeftLine(line);
        this.setBottomLine(line);
        this.setRightLine(line);
    }

    public LineProperties getTopLeft2BottomRightLine() {
        return this.topLeft2BottomRightLine;
    }

    public void setTopLeft2BottomRightLine(LineProperties topLeft2BottomRightLine) {
        this.topLeft2BottomRightLine = topLeft2BottomRightLine;
    }

    public LineProperties getTopRight2BottomLeftLine() {
        return this.topRight2BottomLeftLine;
    }

    public void setTopRight2BottomLeftLine(LineProperties topRight2BottomLeftLine) {
        this.topRight2BottomLeftLine = topRight2BottomLeftLine;
    }

    public CellBorder clone() {
        CellBorder cb = new CellBorder(this.getTopLine(), this.getLeftLine(), this.getBottomLine(), this.getRightLine());
        cb.setTopLeft2BottomRightLine(this.getTopLeft2BottomRightLine());
        cb.setTopRight2BottomLeftLine(this.getTopRight2BottomLeftLine());
        return cb;
    }

    public static CellBorder merge(CellBorder primaryBorders, CellBorder secondaryBorders) {
        CellBorder mergedBorders = new CellBorder(LineProperties.EMPTY_LINE);
        if (primaryBorders.getTopLine() != LineProperties.EMPTY_LINE) {
            mergedBorders.setTopLine(primaryBorders.getTopLine());
        } else {
            mergedBorders.setTopLine(secondaryBorders.getTopLine());
        }
        if (primaryBorders.getLeftLine() != LineProperties.EMPTY_LINE) {
            mergedBorders.setLeftLine(primaryBorders.getLeftLine());
        } else {
            mergedBorders.setLeftLine(secondaryBorders.getLeftLine());
        }
        if (primaryBorders.getBottomLine() != LineProperties.EMPTY_LINE) {
            mergedBorders.setBottomLine(primaryBorders.getBottomLine());
        } else {
            mergedBorders.setBottomLine(secondaryBorders.getBottomLine());
        }
        if (primaryBorders.getRightLine() != LineProperties.EMPTY_LINE) {
            mergedBorders.setRightLine(primaryBorders.getRightLine());
        } else {
            mergedBorders.setRightLine(secondaryBorders.getRightLine());
        }
        return mergedBorders;
    }

    public static CellBorder merge(TableBorder tableBorder, CellBorder secondaryBorders) {
        if (secondaryBorders == null) {
            return new CellBorder(tableBorder);
        }
        return CellBorder.merge(new CellBorder(tableBorder), secondaryBorders);
    }
}

