/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements;

import com.inet.cache.image.SerializableImage;
import com.inet.docx.document.utilities.Util;
import com.microsoft.schemas.office.office.STBWMode;
import com.microsoft.schemas.office.office.STScreenSize;
import com.microsoft.schemas.vml.CTFill;
import com.microsoft.schemas.vml.STFillType;
import com.microsoft.schemas.vml.impl.CTBackgroundImpl;
import java.awt.Color;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBackground;

public class PageBackground {
    private static final String DOCUMENT_PART = "_/word/document.xml";
    private Color pageBackGroundColor = Color.WHITE;
    private String imageKey = null;
    private String fillType = null;
    private String screenSize = null;
    private String bwMode = null;
    SerializableImage image = null;

    public PageBackground() {
    }

    public PageBackground(CTBackground bg) {
        this.pageBackGroundColor = Util.getColorFromObject(bg.getColor(), Color.WHITE);
        XmlCursor cursor = bg.newCursor();
        cursor.selectPath("./*");
        while (cursor.toNextSelection()) {
            STFillType.Enum ft;
            CTFill ctFill;
            STBWMode.Enum bwm;
            XmlObject runObj = cursor.getObject();
            if (!(runObj instanceof CTBackgroundImpl)) continue;
            CTBackgroundImpl bgObj = (CTBackgroundImpl)runObj;
            STScreenSize.Enum tss = bgObj.getTargetscreensize();
            if (tss != null) {
                this.screenSize = tss.toString();
            }
            if ((bwm = bgObj.getBwmode()) != null) {
                this.bwMode = bwm.toString();
            }
            if ((ctFill = bgObj.getFill()) == null) continue;
            if (ctFill.isSetId2()) {
                this.imageKey = ctFill.getId2() + DOCUMENT_PART;
            }
            if ((ft = ctFill.getType()) == null) continue;
            this.fillType = ft.toString();
        }
    }

    public PageBackground(PageBackground original, SerializableImage image) {
        this.image = image;
        this.imageKey = original.imageKey;
        this.screenSize = original.screenSize;
        this.bwMode = original.bwMode;
        this.fillType = original.fillType;
        this.pageBackGroundColor = original.pageBackGroundColor;
    }

    public Color getBackGroundColor() {
        return this.pageBackGroundColor;
    }

    public String getImageKey() {
        return this.imageKey;
    }

    public SerializableImage getPageBackGroundImage() {
        return this.image;
    }

    public String getScreenSize() {
        return this.screenSize;
    }

    public String getBwMode() {
        return this.bwMode;
    }

    public String getFillType() {
        return this.fillType;
    }
}

