/*
 * Decompiled with CFR 0.152.
 */
package com.inet.docx.document.elements;

import com.inet.docx.document.elements.DocumentElement;
import com.inet.docx.document.paragraph.ParagraphData;
import com.inet.docx.document.utilities.Util;
import com.inet.docx.view.PageProperties;
import java.util.List;

public class HeaderFooter {
    private int baseline;
    private boolean isHeader;
    private List<DocumentElement> elements;

    private HeaderFooter() {
    }

    public HeaderFooter(List<DocumentElement> elements, PageProperties pageProps, boolean isHeader) {
        this.elements = elements;
        this.isHeader = isHeader;
        this.baseline = isHeader ? pageProps.getHeaderTop() : pageProps.getPageHeight() - pageProps.getFooterBottom();
    }

    public List<DocumentElement> getElements() {
        return this.elements;
    }

    public boolean isEmpty() {
        if (this.elements == null) {
            return true;
        }
        for (DocumentElement ele : this.elements) {
            if (ele instanceof ParagraphData) {
                ParagraphData pa = (ParagraphData)ele;
                if (pa.isEmpty()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public int getBaseline() {
        return this.baseline;
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public HeaderFooter clone() {
        HeaderFooter theClone = new HeaderFooter();
        theClone.isHeader = this.isHeader;
        theClone.baseline = this.baseline;
        if (this.elements != null) {
            theClone.elements = Util.cloneData(this.elements);
        }
        return theClone;
    }
}

