/*
 * Decompiled with CFR 0.152.
 */
package com.inet.emf.records.state;

import com.inet.emf.EmfRecordExecutor;
import com.inet.emf.EmfRecords;
import com.inet.emf.EmfUtil;

public class SetPolyfillModeRecord
extends EmfRecords {
    private PolygonFillMode fillMode;

    @Override
    public void readContent(byte[] source, int offset) {
        this.fillMode = PolygonFillMode.getValue(EmfUtil.read4BytesInteger(source, offset));
    }

    @Override
    public void execute(EmfRecordExecutor executor) {
        switch (this.fillMode) {
            case ALTERNATE: {
                executor.setWindingRule(1);
                break;
            }
            case WINDING: {
                executor.setWindingRule(0);
            }
        }
    }

    @Override
    public String toString() {
        return "SetPolyfillModeRecord{type=" + this.getType() + ", size=" + this.getSize() + ", fillMode=" + String.valueOf((Object)this.fillMode) + "}";
    }

    public static enum PolygonFillMode {
        ALTERNATE(1),
        WINDING(2);

        private final int id;

        private PolygonFillMode(int id) {
            this.id = id;
        }

        public static PolygonFillMode getValue(int id) {
            for (PolygonFillMode value : PolygonFillMode.values()) {
                if (value.id != id) continue;
                return value;
            }
            EmfUtil.getLogger().debug((Object)("PolygonFillMode with the id " + id + " didn't exist"));
            return ALTERNATE;
        }
    }
}

