/*
 * Decompiled with CFR 0.152.
 */
package com.inet.emf.records.state;

import com.inet.emf.EmfRecordExecutor;
import com.inet.emf.EmfRecords;
import com.inet.emf.EmfUtil;

public class SetMapMode
extends EmfRecords {
    private MapMode mapMode;

    @Override
    public void readContent(byte[] source, int offset) {
        this.mapMode = MapMode.getValue(EmfUtil.read4BytesInteger(source, offset));
    }

    @Override
    public void execute(EmfRecordExecutor executor) {
        executor.setShouldUse(this.mapMode == MapMode.ANISOTROPIC || this.mapMode == MapMode.ISOTROPIC);
    }

    @Override
    public String toString() {
        return "SetMapMode{type=" + this.getType() + ", size=" + this.getSize() + ", mapMode=" + String.valueOf((Object)this.mapMode) + "}";
    }

    public static enum MapMode {
        TEXT(1),
        LOMETRIC(2),
        HIMETRIC(3),
        LOENGLISH(4),
        HIENGLISH(5),
        TWIPS(6),
        ISOTROPIC(7),
        ANISOTROPIC(8);

        private final int id;

        private MapMode(int id) {
            this.id = id;
        }

        public static MapMode getValue(int id) {
            for (MapMode value : MapMode.values()) {
                if (value.id != id) continue;
                return value;
            }
            EmfUtil.getLogger().debug((Object)("MapMode with the id " + id + " didn't exist"));
            return TEXT;
        }
    }
}

