/*
 * Decompiled with CFR 0.152.
 */
package com.inet.emf.records.object;

import com.inet.emf.EmfGraphic;
import com.inet.emf.EmfRecordExecutor;
import com.inet.emf.EmfUtil;
import com.inet.emf.GraphicObject;
import com.inet.emf.records.object.BaseObjectModifier;
import java.awt.Color;

public class CreateBrushIndirect
extends BaseObjectModifier
implements GraphicObject {
    private BrushStyle style;
    private Color color;
    private int brushHatch;

    public CreateBrushIndirect() {
    }

    public CreateBrushIndirect(BrushStyle brushStyle, Color color) {
        this.style = brushStyle;
        this.color = color;
    }

    @Override
    public void readContent(byte[] source, int offset) {
        this.ihObject = EmfUtil.read4BytesInteger(source, offset);
        this.style = BrushStyle.getValue(EmfUtil.read4BytesInteger(source, offset + 4));
        this.color = EmfUtil.readColor(source, offset + 8);
        this.brushHatch = EmfUtil.read4BytesInteger(source, offset + 12);
    }

    @Override
    public void execute(EmfRecordExecutor executor) {
        executor.setGraphicObject(this.ihObject, this);
    }

    @Override
    public void changeGraphics(EmfGraphic graphics2D) {
        switch (this.style) {
            case SOLID: {
                graphics2D.setBackground(this.color);
                break;
            }
            case NULL: {
                graphics2D.setBackground(null);
                break;
            }
            case HATCHED: 
            case PATTERN: 
            case INDEXED: 
            case DIBPATTERN: 
            case DIBPATTERNPT: 
            case PATTERN8X8: 
            case DIBPATTERN8X8: 
            case MONOPATTERN: {
                EmfUtil.getLogger().warn((Object)("BrushStyle " + this.style.name() + " is not implemented."));
            }
        }
    }

    @Override
    public String toString() {
        return "CreateBrushIndirect{type=" + this.getType() + ", size=" + this.getSize() + ", ihBrush=" + this.ihObject + ", color=" + String.valueOf(this.color) + ", brushHatch=" + this.brushHatch + "}";
    }

    public static enum BrushStyle {
        SOLID(0),
        NULL(1),
        HATCHED(2),
        PATTERN(3),
        INDEXED(4),
        DIBPATTERN(5),
        DIBPATTERNPT(6),
        PATTERN8X8(7),
        DIBPATTERN8X8(8),
        MONOPATTERN(9);

        private final int id;

        private BrushStyle(int id) {
            this.id = id;
        }

        public static BrushStyle getValue(int id) {
            switch (id) {
                case 4: 
                case 7: 
                case 8: 
                case 9: {
                    EmfUtil.getLogger().warn((Object)("BrushStyle with the id " + id + " is not support."));
                    return SOLID;
                }
            }
            for (BrushStyle value : BrushStyle.values()) {
                if (value.id != id) continue;
                return value;
            }
            EmfUtil.getLogger().debug((Object)("BrushStyle with the id " + id + " didn't exist"));
            return SOLID;
        }
    }
}

