/*
 * Decompiled with CFR 0.152.
 */
package com.inet.emf.records.header;

import com.inet.emf.EmfRecordExecutor;
import com.inet.emf.EmfRecords;
import com.inet.emf.EmfUtil;
import com.inet.emf.records.header.EmfDescriptionBuffer;
import com.inet.emf.records.header.EmfPixelFormat;
import com.inet.emf.records.header.HeaderExtension1;
import com.inet.emf.records.header.HeaderExtension2;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class HeaderRecord
extends EmfRecords {
    private Rectangle bounds;
    private Rectangle2D frame;
    private RECORDSIGNATURE signature;
    private int version;
    private int filesize;
    private int numOfRecords;
    private int numOfGraphicsObject;
    private int reserved;
    private int nDescription;
    private int offsetToDescription;
    private int nPalEntries;
    private Dimension device;
    private Dimension deviceSizeMM;
    private EmfDescriptionBuffer description;
    private HeaderExtension1 extension1;
    private EmfPixelFormat pixelFormat;
    private HeaderExtension2 extension2;

    int getNumOfRecords() {
        return this.numOfRecords;
    }

    int getNumOfGraphicsObject() {
        return this.numOfGraphicsObject;
    }

    int getnDescription() {
        return this.nDescription;
    }

    int getOffsetToDescription() {
        return this.offsetToDescription;
    }

    @Override
    public void readContent(byte[] source, int offset) {
        int x = EmfUtil.read4BytesInteger(source, offset);
        int y = EmfUtil.read4BytesInteger(source, offset + 4);
        this.bounds = new Rectangle(x, y, EmfUtil.read4BytesInteger(source, offset + 8) - x + 1, EmfUtil.read4BytesInteger(source, offset + 12) - y + 1);
        double x_mm = (double)EmfUtil.read4BytesInteger(source, offset += 16) * 0.01;
        double y_mm = (double)EmfUtil.read4BytesInteger(source, offset + 4) * 0.01;
        this.frame = new Rectangle2D.Double(x_mm, y_mm, (double)EmfUtil.read4BytesInteger(source, offset + 8) * 0.01 - x_mm, (double)EmfUtil.read4BytesInteger(source, offset + 12) * 0.01 - y_mm);
        byte[] signature = new byte[]{EmfUtil.readByte(source, offset += 16), EmfUtil.readByte(source, offset + 1), EmfUtil.readByte(source, offset + 2), EmfUtil.readByte(source, offset + 3)};
        String value = new String(signature).trim();
        for (RECORDSIGNATURE recordsignature : RECORDSIGNATURE.values()) {
            if (!recordsignature.name().equalsIgnoreCase(value)) continue;
            this.signature = recordsignature;
        }
        if (this.signature == null) {
            throw new RuntimeException("Invalid Signature. Current signature value is " + value);
        }
        this.version = EmfUtil.read4BytesInteger(source, offset += 4);
        this.filesize = EmfUtil.read4BytesInteger(source, offset + 4);
        this.numOfRecords = EmfUtil.read4BytesInteger(source, offset + 8);
        this.numOfGraphicsObject = EmfUtil.read2BytesInteger(source, offset + 12);
        this.reserved = EmfUtil.read2BytesInteger(source, offset + 14);
        this.nDescription = EmfUtil.read4BytesInteger(source, offset += 16);
        this.offsetToDescription = EmfUtil.read4BytesInteger(source, offset + 4);
        this.nPalEntries = EmfUtil.read4BytesInteger(source, offset + 8);
        this.device = new Dimension(EmfUtil.read4BytesInteger(source, offset += 12), EmfUtil.read4BytesInteger(source, offset + 4));
        this.deviceSizeMM = new Dimension(EmfUtil.read4BytesInteger(source, offset + 8), EmfUtil.read4BytesInteger(source, offset + 12));
        this.description = new EmfDescriptionBuffer(this);
        int sizeDescription = this.description.read(source, this.offsetToDescription);
        if (this.getSize() > 88 + sizeDescription) {
            this.extension1 = new HeaderExtension1();
            this.extension1.read(source, 88);
            this.pixelFormat = new EmfPixelFormat(this.extension1);
            int sizePixelFormat = this.pixelFormat.read(source, this.offsetToDescription + this.nDescription * 2);
            if (this.getSize() > 100 + sizeDescription + sizePixelFormat) {
                this.extension2 = new HeaderExtension2();
                this.extension2.read(source, 100);
            }
        }
    }

    @Override
    public void execute(EmfRecordExecutor executor) {
        executor.initialize((int)Math.abs(this.bounds.getX() - this.bounds.getWidth()), (int)Math.abs(this.bounds.getY() - this.bounds.getHeight()), this.numOfGraphicsObject);
    }

    @Override
    public String toString() {
        return "HeaderRecord{bounds=" + String.valueOf(this.bounds) + ", frame=" + String.valueOf(this.frame) + ", signature=" + String.valueOf((Object)this.signature) + ", version=" + this.version + ", filesize=" + this.filesize + ", numOfRecords=" + this.numOfRecords + ", numOfGraphicsObject=" + this.numOfGraphicsObject + ", reserved=" + this.reserved + ", nDescription=" + this.nDescription + ", offsetToDescription=" + this.offsetToDescription + ", nPalEntries=" + this.nPalEntries + ", device=" + String.valueOf(this.device) + ", deviceSizeMM=" + String.valueOf(this.deviceSizeMM) + ", description=" + String.valueOf(this.description) + ", extension1=" + String.valueOf(this.extension1) + ", pixelFormat=" + String.valueOf(this.pixelFormat) + ", extension2=" + String.valueOf(this.extension2) + "}";
    }

    static enum RECORDSIGNATURE {
        EMF,
        EPS;

    }
}

