/*
 * Decompiled with CFR 0.152.
 */
package com.inet.emf.records.drawing;

import com.inet.emf.EmfRecordExecutor;
import com.inet.emf.EmfRecords;
import com.inet.emf.EmfUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;

public class PolylineRecord
extends EmfRecords {
    Rectangle area;
    Point[] points;

    @Override
    public void readContent(byte[] source, int offset) {
        this.area = EmfUtil.readRectangle(source, offset);
        int numOfPoints = EmfUtil.read4BytesInteger(source, offset + 16);
        this.points = new Point[numOfPoints];
        offset += 20;
        for (int i = 0; i < numOfPoints; ++i) {
            this.points[i] = EmfUtil.readPoint(source, offset);
            offset += 8;
        }
    }

    @Override
    public void execute(EmfRecordExecutor executor) {
        for (int i = 0; i < this.points.length; i += 3) {
            executor.getPath().lineTo(this.points[i].getX(), this.points[i].getY());
        }
    }

    @Override
    public String toString() {
        return "PolylineRecord{type=" + this.getType() + ", size=" + this.getSize() + ", area=" + String.valueOf(this.area) + ", points=" + Arrays.toString(this.points) + "}";
    }
}

