/*
 * Decompiled with CFR 0.152.
 */
package com.inet.emf.records.drawing;

import com.inet.emf.EmfRecordExecutor;
import com.inet.emf.EmfRecords;
import com.inet.emf.EmfUtil;

public class PathRecord
extends EmfRecords {
    private Type type;

    public PathRecord(Type type) {
        this.type = type;
    }

    @Override
    public void readContent(byte[] source, int offset) {
    }

    @Override
    public void execute(EmfRecordExecutor executor) {
        switch (this.type) {
            case ABORTPATH: {
                executor.getPath().reset();
                break;
            }
            case BEGINPATH: {
                executor.createPath();
                break;
            }
            case CLOSEFIGURE: {
                executor.getPath().closePath();
                break;
            }
            case ENDPATH: {
                executor.selectPath();
                break;
            }
            case FLATTENPATH: {
                EmfUtil.getLogger().debug((Object)"Not implement PathRecord -> FLATTENPATH");
                break;
            }
            case WIDENPATH: {
                EmfUtil.getLogger().debug((Object)"Not implement PathRecord -> WIDENPATH");
            }
        }
    }

    @Override
    public String toString() {
        return "PathRecords{type=" + this.getType() + ", size=" + this.getSize() + ", subtype=" + String.valueOf((Object)this.type) + "}";
    }

    public static enum Type {
        ABORTPATH,
        BEGINPATH,
        CLOSEFIGURE,
        ENDPATH,
        FLATTENPATH,
        WIDENPATH;

    }
}

