/*
 * Decompiled with CFR 0.152.
 */
package com.inet.emf.records.bitmap;

import com.inet.emf.EmfRecordExecutor;
import com.inet.emf.EmfRecords;
import com.inet.emf.EmfUtil;
import com.inet.emf.records.bitmap.BitmapInfoHeader;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class StretchDiBitsRecord
extends EmfRecords {
    private BitmapInfoHeader bitmapInfoHeader;
    private BufferedImage image;
    private Rectangle bounds;
    private Rectangle srcImageArea;
    private Rectangle destImageArea;
    private DIBColors dibColors;

    @Override
    public void readContent(byte[] source, int offset) {
        this.bounds = EmfUtil.readRectangle(source, offset);
        int xDest = EmfUtil.read4BytesInteger(source, offset + 16);
        int yDest = EmfUtil.read4BytesInteger(source, offset + 20);
        int xSrc = EmfUtil.read4BytesInteger(source, offset + 24);
        int ySrc = EmfUtil.read4BytesInteger(source, offset + 28);
        int cxSrc = EmfUtil.read4BytesInteger(source, offset + 32);
        int cySrc = EmfUtil.read4BytesInteger(source, offset + 36);
        int offBmiSrc = EmfUtil.read4BytesInteger(source, offset + 40);
        int cbBmiSrc = EmfUtil.read4BytesInteger(source, offset + 44);
        int offBitsSrc = EmfUtil.read4BytesInteger(source, offset + 48);
        int cbBitsSrc = EmfUtil.read4BytesInteger(source, offset + 52);
        this.dibColors = DIBColors.getValue(EmfUtil.read4BytesInteger(source, offset + 56));
        int bitBltRasterOperation = EmfUtil.read4BytesInteger(source, offset + 60);
        int cxDest = EmfUtil.read4BytesInteger(source, offset + 64);
        int cyDest = EmfUtil.read4BytesInteger(source, offset + 68);
        this.srcImageArea = new Rectangle(xSrc, ySrc, cxSrc, cySrc);
        this.destImageArea = new Rectangle(xDest, yDest, cxDest, cyDest);
        byte[] header = new byte[cbBmiSrc];
        System.arraycopy(source, offset - 8 + offBmiSrc, header, 0, header.length);
        this.bitmapInfoHeader = new BitmapInfoHeader();
        this.bitmapInfoHeader.read(header, 0);
        byte[] imageData = new byte[cbBitsSrc];
        System.arraycopy(source, offset - 8 + offBitsSrc, imageData, 0, imageData.length);
        this.image = this.convert(this.bitmapInfoHeader, imageData);
        this.image = this.image.getSubimage(this.srcImageArea.x, this.srcImageArea.y, this.srcImageArea.width, this.srcImageArea.height);
    }

    private BufferedImage convert(BitmapInfoHeader bitmapInfoHeader, byte[] imageData) {
        BufferedImage bufferedImage = null;
        switch (bitmapInfoHeader.getCompression()) {
            case BI_RGB: {
                bufferedImage = new BufferedImage(bitmapInfoHeader.getWidth(), bitmapInfoHeader.getHeight(), 6);
                PixelInterleavedSampleModel pixelInterleveadSampeModel = new PixelInterleavedSampleModel(0, bufferedImage.getWidth(), bufferedImage.getHeight(), 4, bufferedImage.getWidth() * 4, new int[]{2, 1, 0, 3});
                WritableRaster writableRaster = Raster.createWritableRaster(pixelInterleveadSampeModel, new DataBufferByte(imageData, imageData.length), new Point(0, 0));
                bufferedImage.setData(writableRaster);
            }
        }
        return bufferedImage;
    }

    @Override
    public void execute(EmfRecordExecutor executor) {
        Rectangle target = new Rectangle(this.destImageArea.x, this.destImageArea.y + this.destImageArea.height, this.destImageArea.width, -this.destImageArea.height);
        executor.drawImage(this.image, target);
    }

    @Override
    public String toString() {
        return "StretchDiBitsRecord{type=" + this.getType() + ", size=" + this.getSize() + ", bitmapInfoHeader=" + String.valueOf(this.bitmapInfoHeader) + ", bounds=" + String.valueOf(this.bounds) + ", srcImageArea=" + String.valueOf(this.srcImageArea) + ", destImageArea=" + String.valueOf(this.destImageArea) + ", dibColors=" + String.valueOf((Object)this.dibColors) + "}";
    }

    public static enum DIBColors {
        RGB_COLORS(0),
        PAL_COLORS(1),
        INDICES(2);

        private final int id;

        private DIBColors(int id) {
            this.id = id;
        }

        public static DIBColors getValue(int id) {
            for (DIBColors value : DIBColors.values()) {
                if (value.id != id) continue;
                return value;
            }
            EmfUtil.getLogger().debug((Object)("DIBColors with the id " + id + " didn't exist"));
            return RGB_COLORS;
        }
    }
}

