/*
 * Decompiled with CFR 0.152.
 */
package com.inet.emf.records;

import com.inet.emf.EmfRecordExecutor;
import com.inet.emf.EmfRecords;
import com.inet.emf.EmfUtil;
import java.awt.Rectangle;

public class StrokePathRecord
extends EmfRecords {
    private Rectangle drawingArea;
    private Type type;

    public StrokePathRecord(Type type) {
        this.type = type;
    }

    @Override
    public void readContent(byte[] source, int offset) {
        this.drawingArea = EmfUtil.readRectangle(source, offset);
    }

    @Override
    public void execute(EmfRecordExecutor executor) {
        switch (this.type) {
            case FILL: {
                executor.fillPath();
                break;
            }
            case STROKE: {
                executor.drawPath();
                break;
            }
            case STROKEANDFILLPATH: {
                executor.getPath().closePath();
                executor.fillPath();
                executor.drawPath();
            }
        }
    }

    @Override
    public String toString() {
        return "StrokePathRecord " + String.valueOf((Object)this.type) + "{type=" + this.getType() + ", size=" + this.getSize() + ", drawingArea=" + String.valueOf(this.drawingArea) + "}";
    }

    public static enum Type {
        FILL,
        STROKE,
        STROKEANDFILLPATH;

    }
}

