/*
 * Decompiled with CFR 0.152.
 */
package com.inet.oauth.connection.api.token;

import com.inet.annotations.InternalApi;
import com.inet.cache.MemoryStoreMap;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.error.ErrorCode;
import com.inet.http.error.HttpFailedException;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.oauth.connection.api.provider.OauthConnectionProvider;
import com.inet.oauth.connection.api.token.a;
import com.inet.oauth.connection.structure.OauthSettings;
import com.inet.plugin.ServerPluginManager;
import com.inet.thread.ThreadUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class OauthAccessTokenManager {
    private static final Logger i = LogManager.getConfigLogger();
    private static final MemoryStoreMap<String, a> j = new MemoryStoreMap(3600, true);
    private static final Map<String, OauthConnectionProvider> k;
    private static final ConfigValue<String> l;
    private static final SecureRandom m;
    static final MemoryStoreMap<String, String> n;
    private static final ConfigValue<Map<String, OauthSettings>> o;

    @Nonnull
    public static String getRedirectUrl() {
        String string = (String)l.get();
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string + "/oauth/redirect";
    }

    @Nonnull
    public static Collection<String> getConfiguredProviderIDs() {
        return Collections.unmodifiableSet(((Map)o.get()).keySet());
    }

    @SuppressFBWarnings(value={"UNVALIDATED_REDIRECT"}, justification="Redirect is part of the login process")
    static void a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = httpServletRequest.getParameter("provider");
        String string2 = httpServletRequest.getParameter("scope");
        String string3 = new BigInteger(130, m).toString(32);
        String string4 = OauthAccessTokenManager.getAuthenticationURL(string, string3, string2);
        n.put((Object)string3, (Object)string);
        httpServletResponse.sendRedirect(string4);
    }

    @Nonnull
    public static String getAuthenticationURL(String providerID, String state, String scope) {
        if (providerID == null) {
            throw new HttpFailedException(404, "provider parameter missing");
        }
        OauthConnectionProvider oauthConnectionProvider = k.get(providerID);
        if (oauthConnectionProvider == null) {
            throw new HttpFailedException(404, "unknown provider " + providerID);
        }
        OauthSettings oauthSettings = (OauthSettings)((Map)o.get()).get(providerID);
        if (oauthSettings == null) {
            throw new HttpFailedException(404, "no settings for provider " + providerID);
        }
        if (scope == null) {
            throw new HttpFailedException(404, "scope parameter missing");
        }
        return oauthConnectionProvider.getAuthenticationURL(oauthSettings, state, scope);
    }

    @Nonnull
    public static String getTokenURL(String providerID) {
        if (providerID == null) {
            throw new HttpFailedException(404, "provider parameter missing");
        }
        OauthConnectionProvider oauthConnectionProvider = k.get(providerID);
        if (oauthConnectionProvider == null) {
            throw new HttpFailedException(404, "unknown provider " + providerID);
        }
        OauthSettings oauthSettings = (OauthSettings)((Map)o.get()).get(providerID);
        if (oauthSettings == null) {
            throw new HttpFailedException(404, "no settings for provider " + providerID);
        }
        return oauthConnectionProvider.getTokenURL(oauthSettings);
    }

    @Nonnull
    public static String getTokenData(String providerID, String code) {
        if (providerID == null) {
            throw new HttpFailedException(404, "provider parameter missing");
        }
        OauthConnectionProvider oauthConnectionProvider = k.get(providerID);
        if (oauthConnectionProvider == null) {
            throw new HttpFailedException(404, "unknown provider " + providerID);
        }
        OauthSettings oauthSettings = (OauthSettings)((Map)o.get()).get(providerID);
        if (oauthSettings == null) {
            throw new HttpFailedException(404, "no settings for provider " + providerID);
        }
        return oauthConnectionProvider.getTokenData(oauthSettings, code, null);
    }

    @Nonnull
    public static String getAccessToken(@Nonnull String provider, @Nonnull String refresh_token, @Nonnull Consumer<String> saveCallback) {
        return OauthAccessTokenManager.getAccessToken(provider, refresh_token, 60, saveCallback);
    }

    @Nonnull
    public static String getAccessToken(@Nonnull String provider, @Nonnull String refresh_token, int neededTime, @Nonnull Consumer<String> saveCallback) {
        a a2 = (a)j.get((Object)refresh_token);
        if (a2 != null && !a2.a(neededTime)) {
            return a2.a();
        }
        a2 = OauthAccessTokenManager.a(provider, null, refresh_token, neededTime, saveCallback);
        return a2.a();
    }

    public static String getRefreshToken(@Nonnull String provider, @Nonnull String code) {
        String[] stringArray = new String[1];
        OauthAccessTokenManager.a(provider, code, null, 0, string -> {
            stringArray[0] = string;
        });
        return stringArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Fix service URL is used")
    private static a a(@Nonnull String string, @Nullable String string2, @Nullable String string3, int n, @Nonnull Consumer<String> consumer) {
        OauthConnectionProvider oauthConnectionProvider = k.get(string);
        if (oauthConnectionProvider == null) {
            throw new IllegalArgumentException("Unknown OAuth provider ID: " + string);
        }
        OauthSettings oauthSettings = (OauthSettings)((Map)o.get()).get(string);
        if (oauthSettings == null) {
            throw new IllegalArgumentException("There are no OAuth settings for the provider: " + string);
        }
        try (ThreadUtils.Semaphore semaphore = ThreadUtils.getSemaphore((Object)(string2 + string3));){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                int n2;
                Object object;
                Object object2;
                Object object3;
                a a2;
                if (string3 != null && (a2 = (a)j.get((Object)string3)) != null && !a2.a(n)) {
                    a a3 = a2;
                    return a3;
                }
                URL uRL = new URL(oauthConnectionProvider.getTokenURL(oauthSettings));
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.addRequestProperty("Accept", "application/json; charset=utf-8");
                httpURLConnection.setConnectTimeout(20000);
                httpURLConnection.setReadTimeout(20000);
                httpURLConnection.setDoOutput(true);
                String string4 = oauthConnectionProvider.getTokenData(oauthSettings, string2, string3);
                try (Object object4 = httpURLConnection.getOutputStream();){
                    ((OutputStream)object4).write(string4.getBytes(StandardCharsets.UTF_8));
                }
                object4 = null;
                try {
                    object3 = httpURLConnection.getInputStream();
                    try {
                        object4 = IOFunctions.readString((InputStream)object3, (Charset)StandardCharsets.UTF_8);
                    }
                    finally {
                        if (object3 != null) {
                            ((InputStream)object3).close();
                        }
                    }
                }
                catch (IOException iOException) {
                    object2 = httpURLConnection.getErrorStream();
                    if (object2 == null) throw iOException;
                    object4 = IOFunctions.readString((InputStream)object2, (Charset)StandardCharsets.UTF_8);
                }
                object3 = (HashMap)new Json().fromJson((String)object4, HashMap.class);
                object2 = (String)((HashMap)object3).get("access_token");
                if (object2 == null) {
                    i.error(object4);
                    throw new IOException("No access token received: " + (String)((HashMap)object3).get("error_description"));
                }
                String string5 = (String)((HashMap)object3).get("refresh_token");
                if (string3 == null && string5 == null) {
                    throw new IllegalArgumentException("No refresh token received.");
                }
                try {
                    object = ((HashMap)object3).get("expires_in");
                    n2 = object instanceof Number ? ((Number)object).intValue() : Integer.parseInt(String.valueOf(object));
                }
                catch (Exception exception) {
                    n2 = 3600;
                }
                a2 = new a((String)object2, n2);
                if (string5 != null && !string5.equals(string3)) {
                    j.put((Object)string5, (Object)a2);
                    consumer.accept(string5);
                }
                if (string3 != null) {
                    j.put((Object)string3, (Object)a2);
                }
                object = a2;
                return object;
            }
        }
        catch (Exception exception) {
            i.error((Throwable)exception);
            throw (RuntimeException)ErrorCode.throwAny((Throwable)exception);
        }
    }

    @Nullable
    public static OauthConnectionProvider getProvider(String providerID) {
        return k.get(providerID);
    }

    static {
        HashMap<String, OauthConnectionProvider> hashMap = new HashMap<String, OauthConnectionProvider>();
        for (OauthConnectionProvider oauthConnectionProvider : ServerPluginManager.getInstance().get(OauthConnectionProvider.class)) {
            hashMap.put(oauthConnectionProvider.getName(), oauthConnectionProvider);
        }
        k = hashMap;
        l = new ConfigValue(ConfigKey.SERVER_URL);
        m = new SecureRandom();
        n = new MemoryStoreMap(900, false);
        o = new ConfigValue<Map<String, OauthSettings>>(com.inet.oauth.connection.structure.a.p){

            protected Map<String, OauthSettings> a(@Nonnull String string) throws IllegalArgumentException {
                ArrayList arrayList = (ArrayList)new Json().fromJson(string, ArrayList.class, new Type[]{OauthSettings.class});
                LinkedHashMap<String, OauthSettings> linkedHashMap = new LinkedHashMap<String, OauthSettings>();
                for (OauthSettings oauthSettings : arrayList) {
                    linkedHashMap.put(oauthSettings.getProviderID(), oauthSettings);
                }
                return linkedHashMap;
            }

            protected /* synthetic */ Object convert(@Nonnull String string) throws IllegalArgumentException {
                return this.a(string);
            }
        };
    }
}

