/*
 * Decompiled with CFR 0.152.
 */
package com.inet.oauth.connection.api.provider;

import com.inet.annotations.InternalApi;
import com.inet.lib.util.StringFunctions;
import com.inet.oauth.connection.api.provider.OauthConnectionProvider;
import com.inet.oauth.connection.structure.OauthSettings;
import java.net.URL;
import javax.annotation.Nonnull;

@InternalApi
public class Office365ConnectionProvider
extends OauthConnectionProvider {
    public static final String NAME = "office365";

    @Override
    @Nonnull
    public String getName() {
        return NAME;
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        return "Office 365";
    }

    @Override
    public URL getIconURL() {
        return this.getClass().getResource("/com/inet/oauth/connection/images/office_32.png");
    }

    @Override
    String a(@Nonnull OauthSettings oauthSettings) {
        String string = oauthSettings.getTenant();
        if (StringFunctions.isEmpty((String)string)) {
            string = "common";
        }
        return "https://login.microsoftonline.com/" + string + "/v2.0/.well-known/openid-configuration";
    }
}

