/*
 * Decompiled with CFR 0.152.
 */
package com.inet.oauth.connection;

import com.inet.classloader.I18nMessages;
import com.inet.config.structure.provider.ConfigStructureProvider;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.http.PluginServlet;
import com.inet.oauth.connection.api.provider.DropboxConnectionProvider;
import com.inet.oauth.connection.api.provider.GoogleConnectionProvider;
import com.inet.oauth.connection.api.provider.OauthConnectionProvider;
import com.inet.oauth.connection.api.provider.Office365ConnectionProvider;
import com.inet.oauth.connection.api.token.b;
import com.inet.oauth.connection.structure.a;
import com.inet.permissions.Permission;
import com.inet.plugin.Executable;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.help.ConfigHelpProvider;
import com.inet.plugin.help.HelpProvider;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.report.plugins.config.server.ConfigAngularApplicationServlet;
import com.inet.theme.server.ThemeResource;
import java.net.URL;

@PluginInfo(id="oauth.connection", version="25.10.198", optionalDependencies="remotegui;configuration;theme", group="communication;integration", packages="com.inet.oauth.connection.api", icon="com/inet/oauth/connection/structure/oauth_connection_48.png", flags="")
public class OauthConnectionServerPlugin
implements ServerPlugin {
    public static final String PLUGIN_ID = "oauth.connection";
    public static final I18nMessages MSG = new I18nMessages("com.inet.oauth.connection.structure.i18n.ConfigStructure", OauthConnectionServerPlugin.class);
    public static final I18nMessages MSG_CONFIG = new I18nMessages("com.inet.oauth.connection.config.i18n.LanguageResources", OauthConnectionServerPlugin.class);

    public void registerHelp(HelpProviderContainer container) {
        container.add((HelpProvider)new ConfigHelpProvider("configuration", 9963, new Permission[]{Permission.valueOfExistingOrCreate((String)"configuration")}){}, new String[0]);
    }

    public void registerExtension(final ServerPluginManager spm) {
        if (!ServerPluginManager.IS_SERVLET_API) {
            return;
        }
        spm.register(ConfigStructureProvider.class, (Object)new a());
        spm.register(OauthConnectionProvider.class, (Object)new Office365ConnectionProvider());
        spm.register(OauthConnectionProvider.class, (Object)new GoogleConnectionProvider());
        spm.register(OauthConnectionProvider.class, (Object)new DropboxConnectionProvider());
        spm.register(PluginServlet.class, (Object)new b());
        FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
        combinedFile.add(this.getClass(), "/com/inet/oauth/connection/config/js/oauthconnection_config.js");
        combinedFile.addMessages(MSG_CONFIG);
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 1001, "configAppExtras.js", combinedFile));
        combinedFile = new FileCombiner.CombinedFile("text/css; charset=utf-8", new URL[0]);
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 201, "defaulttheme.css", combinedFile));
        combinedFile.add(this.getClass(), "/com/inet/oauth/connection/config/css/oauthconnection.css");
        spm.runIfPluginLoaded("theme", () -> new Executable(){

            public void execute() {
                spm.register(ThemeResource.class, (Object)new ThemeResource(200, "remotegui", ((Object)((Object)this)).getClass().getClassLoader().getResource("com/inet/oauth/connection/config/css/oauthconnection.less")));
            }
        });
    }

    public void init(final ServerPluginManager spm) {
        spm.runIfPluginLoaded("configuration", () -> new Executable(){

            public void execute() {
                ConfigAngularApplicationServlet configAngularApplicationServlet = (ConfigAngularApplicationServlet)spm.getSingleInstance(ConfigAngularApplicationServlet.class);
                configAngularApplicationServlet.addServiceMethod((ServiceMethod)new com.inet.oauth.connection.config.a());
            }
        });
    }

    public void reset() {
    }

    public void restart() {
    }
}

