/*
 * Decompiled with CFR 0.152.
 */
package com.inet.notificationui.server.taskplanner;

import com.inet.annotations.InternalApi;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.StringFunctions;
import com.inet.notificationui.NotificationServerPlugin;
import com.inet.notificationui.server.taskplanner.UserAndGroupSelectField;
import com.inet.notificationui.server.taskplanner.b;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.action.ResultActionInfo;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.BooleanField;
import com.inet.taskplanner.server.api.field.DisableCondition;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.LabelField;
import com.inet.taskplanner.server.api.field.TextAreaField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class NotificationResultActionFactory
extends ResultActionFactory<b> {
    public static final String EXTENSION_NAME = "result.notification";
    public static final String PROPERTY_NOTIFICATION_TITLE = "notificationTitle";
    public static final String PROPERTY_NOTIFICATION_MESSAGE = "notificationMessage";
    public static final String PROPERTY_NOTIFICATION_TARGETURL = "notificationTargetURL";
    public static final String PROPERTY_NOTIFICATION_RECEIVER = "notificationReceiver";
    public static final String PROPERTY_NOTIFICATION_RECEIVER_RESTRICTED = "notificationReceiverRestricted";
    public static final String PROPERTY_NOTIFICATION_CRITICAL = "notificationCritical";

    public NotificationResultActionFactory() {
        super(EXTENSION_NAME);
    }

    public ResultActionInfo getInformation(@Nullable GUID taskID) {
        ResultActionInfo resultActionInfo;
        Cloneable cloneable;
        String string = NotificationServerPlugin.MSG.getMsg("result.notification.name", new Object[0]);
        String string2 = NotificationServerPlugin.MSG.getMsg("result.notification.description", new Object[0]);
        URL uRL = ((Object)((Object)this)).getClass().getResource("/com/inet/notificationui/server/taskplanner/notification_32.png");
        String string3 = "taskplanner.action.notification";
        TextField textField = new TextField(PROPERTY_NOTIFICATION_TITLE, NotificationServerPlugin.MSG.getMsg("result.notification.title", new Object[0]));
        TextAreaField textAreaField = new TextAreaField(PROPERTY_NOTIFICATION_MESSAGE, NotificationServerPlugin.MSG.getMsg("result.notification.message", new Object[0]));
        TextField textField2 = new TextField(PROPERTY_NOTIFICATION_TARGETURL, NotificationServerPlugin.MSG.getMsg("result.notification.targetURL", new Object[0]));
        textField2.setPlaceholder(NotificationServerPlugin.MSG.getMsg("result.notification.targetURL.placeholder", new Object[0]));
        BooleanField booleanField = new BooleanField(PROPERTY_NOTIFICATION_CRITICAL, NotificationServerPlugin.MSG.getMsg("result.notification.critical", new Object[0]), NotificationServerPlugin.MSG.getMsg("result.notification.critical.label", new Object[0]));
        UserAndGroupSelectField userAndGroupSelectField = null;
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (ServerPluginManager.getInstance().isPluginLoaded("usersandgroupsmanager") && SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER)) {
            userAndGroupSelectField = new UserAndGroupSelectField(PROPERTY_NOTIFICATION_RECEIVER);
            if (userAccount != null && !userAccount.getID().equals((Object)UserManager.PRIVILEGED_ACCOUNT_ID)) {
                cloneable = new HashMap();
                resultActionInfo = new HashSet();
                resultActionInfo.add(userAccount.getID());
                ((HashMap)cloneable).put(com.inet.usersandgroups.api.ui.Type.user, resultActionInfo);
                ((HashMap)cloneable).put(com.inet.usersandgroups.api.ui.Type.group, new HashSet());
                userAndGroupSelectField.setValue(new Json().toJson((Object)cloneable));
            }
        } else {
            userAndGroupSelectField = userAccount == null || userAccount.getID().equals((Object)UserManager.PRIVILEGED_ACCOUNT_ID) ? new LabelField(PROPERTY_NOTIFICATION_RECEIVER_RESTRICTED, NotificationServerPlugin.MSG.getMsg("result.notification.receiver", new Object[0]), NotificationServerPlugin.MSG.getMsg("result.notification.error.receiverunknown", new Object[0])) : new LabelField(PROPERTY_NOTIFICATION_RECEIVER_RESTRICTED, NotificationServerPlugin.MSG.getMsg("result.notification.receiver", new Object[0]), userAccount.getDisplayName());
            userAndGroupSelectField.setConditions(Arrays.asList(DisableCondition.disabled((Field)textAreaField, (FieldCondition.OP)FieldCondition.OP.notequal, (String)"true")));
        }
        cloneable = new ArrayList<String>();
        cloneable.add("jobresult");
        resultActionInfo = new ResultActionInfo(EXTENSION_NAME, string, string2, uRL, string3, Arrays.asList(new Field[]{textField, textAreaField, textField2, booleanField, userAndGroupSelectField}), (List)((Object)cloneable));
        return resultActionInfo;
    }

    protected void validate(@Nonnull ResultActionDefinition definition, @Nullable GUID taskID) throws ValidationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = definition.getProperty(PROPERTY_NOTIFICATION_TITLE);
        String string2 = definition.getProperty(PROPERTY_NOTIFICATION_MESSAGE);
        this.a(string, arrayList, () -> NotificationServerPlugin.MSG.getMsg("result.notification.error.noTitle", new Object[0]));
        this.a(string2, arrayList, () -> NotificationServerPlugin.MSG.getMsg("result.notification.error.noMessage", new Object[0]));
        if (ServerPluginManager.getInstance().isPluginLoaded("usersandgroupsmanager") && SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER)) {
            String string3 = definition.getProperty(PROPERTY_NOTIFICATION_RECEIVER);
            this.a(string3, arrayList, () -> NotificationServerPlugin.MSG.getMsg("result.notification.error.noReceiver", new Object[0]));
            if (string3 != null && !string3.isEmpty()) {
                HashMap hashMap = null;
                try {
                    hashMap = (HashMap)new Json().fromJson(string3, (Type)new JsonParameterizedType(HashMap.class, new Type[]{com.inet.usersandgroups.api.ui.Type.class, new JsonParameterizedType(HashSet.class, new Type[]{GUID.class})}));
                }
                catch (JsonException jsonException) {
                    hashMap = new HashMap();
                }
                int n = hashMap.get(com.inet.usersandgroups.api.ui.Type.user) == null ? 0 : ((Set)hashMap.get(com.inet.usersandgroups.api.ui.Type.user)).size();
                if ((n += hashMap.get(com.inet.usersandgroups.api.ui.Type.group) == null ? 0 : ((Set)hashMap.get(com.inet.usersandgroups.api.ui.Type.group)).size()) == 0) {
                    arrayList.add(NotificationServerPlugin.MSG.getMsg("result.notification.error.noReceiver", new Object[0]));
                }
            }
        }
        if (!arrayList.isEmpty()) {
            throw new ValidationException(arrayList);
        }
    }

    private void a(String string, List<String> list, Supplier<String> supplier) {
        if (string == null || string.trim().isEmpty()) {
            list.add(supplier.get());
        }
    }

    public SummaryInfo getSummary(@Nonnull ResultActionDefinition definition) {
        HashSet hashSet;
        ArrayList<SummaryEntry> arrayList = new ArrayList<SummaryEntry>();
        arrayList.add(new SummaryEntry(NotificationServerPlugin.MSG.getMsg("result.notification.summary.title", new Object[0]), definition.getProperty(PROPERTY_NOTIFICATION_TITLE)));
        arrayList.add(new SummaryEntry(NotificationServerPlugin.MSG.getMsg("result.notification.summary.message", new Object[0]), definition.getProperty(PROPERTY_NOTIFICATION_MESSAGE)));
        String string = definition.getProperty(PROPERTY_NOTIFICATION_TARGETURL);
        if (!StringFunctions.isEmpty((String)string)) {
            arrayList.add(new SummaryEntry(NotificationServerPlugin.MSG.getMsg("result.notification.summary.targetURL", new Object[0]), string));
        }
        if (Boolean.parseBoolean(definition.getProperty(PROPERTY_NOTIFICATION_CRITICAL))) {
            arrayList.add(new SummaryEntry(NotificationServerPlugin.MSG.getMsg("result.notification.summary.critical", new Object[0]), NotificationServerPlugin.MSG.getMsg("result.notification.summary.critical.label", new Object[0])));
        }
        String string2 = definition.getProperty(PROPERTY_NOTIFICATION_RECEIVER);
        Map map = new HashMap();
        if (string2 != null) {
            try {
                map = (Map)new Json().fromJson(string2, (Type)new JsonParameterizedType(HashMap.class, new Type[]{com.inet.usersandgroups.api.ui.Type.class, new JsonParameterizedType(HashSet.class, new Type[]{GUID.class})}));
            }
            catch (JsonException jsonException) {
                // empty catch block
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        UserManager userManager = UserManager.getInstance();
        UserGroupManager userGroupManager = UserGroupManager.getInstance();
        HashSet hashSet2 = (HashSet)map.get(com.inet.usersandgroups.api.ui.Type.user);
        if (hashSet2 == null) {
            hashSet2 = new HashSet();
        }
        if ((hashSet = (HashSet)map.get(com.inet.usersandgroups.api.ui.Type.group)) == null) {
            hashSet = new HashSet();
        }
        int n = hashSet2.size();
        int n2 = hashSet.size();
        if (ServerPluginManager.getInstance().isPluginLoaded("usersandgroupsmanager") && SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER)) {
            UserAccount userAccount;
            String string3 = "";
            String string4 = "";
            for (GUID gUID : hashSet2) {
                if (gUID == null) continue;
                userAccount = userManager.getUserAccount(gUID);
                if (userAccount != null) {
                    if (!string3.isEmpty()) continue;
                    string3 = userAccount.getDisplayName();
                    continue;
                }
                --n;
            }
            for (GUID gUID : hashSet) {
                if (gUID == null) continue;
                userAccount = userGroupManager.getGroup(gUID);
                if (userAccount != null && userAccount.isActive()) {
                    if (!string4.isEmpty()) continue;
                    string4 = userAccount.getDisplayName();
                    continue;
                }
                --n2;
            }
            if (n2 > 0) {
                stringBuilder.append(NotificationServerPlugin.MSG.getMsg("notificationtemplate.recipient.groups", new Object[]{string4, n2 - 1}));
                if (n > 0) {
                    stringBuilder.append(" ");
                    stringBuilder.append(NotificationServerPlugin.MSG.getMsg("notificationtemplate.recipient.and", new Object[0]));
                    stringBuilder.append(" ");
                }
            }
            if (n > 0) {
                stringBuilder.append(NotificationServerPlugin.MSG.getMsg("notificationtemplate.recipient.users", new Object[]{string3, n - 1}));
            }
        } else {
            UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
            if (userAccount != null && hashSet2.contains(userAccount.getID())) {
                hashSet2.remove(userAccount.getID());
                --n;
            }
            stringBuilder.append(NotificationServerPlugin.MSG.getMsg("notificationtemplate.recipient.users", new Object[]{userAccount.getDisplayName(), 0}));
            if (n2 > 0 || n > 0) {
                stringBuilder.append(NotificationServerPlugin.MSG.getMsg("notificationtemplate.recipient.unabletosendto", new Object[0]));
            }
            if (n2 > 0) {
                stringBuilder.append(NotificationServerPlugin.MSG.getMsg("notificationtemplate.recipient.groupcount", new Object[]{n2}));
                if (n > 0) {
                    stringBuilder.append(" ");
                    stringBuilder.append(NotificationServerPlugin.MSG.getMsg("notificationtemplate.recipient.and2", new Object[0]));
                    stringBuilder.append(" ");
                }
            }
            if (n > 0) {
                stringBuilder.append(NotificationServerPlugin.MSG.getMsg("notificationtemplate.recipient.usercount", new Object[]{n}));
            }
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append(NotificationServerPlugin.MSG.getMsg("result.notification.error.noReceiver", new Object[0]));
        }
        arrayList.add(new SummaryEntry(NotificationServerPlugin.MSG.getMsg("result.notification.summary.receiver", new Object[0]), stringBuilder.toString()));
        return new SummaryInfo(arrayList);
    }

    protected b createInstanceFrom(@Nonnull ResultActionDefinition definition, @Nullable GUID taskID) {
        return new b(definition.getProperty(PROPERTY_NOTIFICATION_TITLE), definition.getProperty(PROPERTY_NOTIFICATION_MESSAGE), definition.getProperty(PROPERTY_NOTIFICATION_TARGETURL), definition.getProperty(PROPERTY_NOTIFICATION_RECEIVER), definition.getProperty(PROPERTY_NOTIFICATION_CRITICAL));
    }

    public List<ResultFlavor> getSupportedFlavors(ResultActionDefinition definition) {
        return Arrays.asList(ResultFlavor.NONE, ResultFlavor.TEXT);
    }
}

