/*
 * Decompiled with CFR 0.152.
 */
package com.inet.notificationui.server.handler;

import com.inet.cache.shutdown.ShutdownManager;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.notification.Notification;
import com.inet.notificationui.NotificationServerPlugin;
import com.inet.notificationui.server.data.GetNotificationResponseData;
import com.inet.notificationui.server.data.GetNotificationsRequestData;
import com.inet.notificationui.server.dispatcher.WebNotificationDispatcher;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.thread.ThreadUtils;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class d
extends ServiceMethod<GetNotificationsRequestData, GetNotificationResponseData> {
    private WebNotificationDispatcher o;

    public d(WebNotificationDispatcher webNotificationDispatcher) {
        this.o = webNotificationDispatcher;
    }

    public String getMethodName() {
        return "notification_getnotifications";
    }

    public short getMethodType() {
        return 1;
    }

    public GetNotificationResponseData a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, GetNotificationsRequestData getNotificationsRequestData) throws IOException {
        Optional<Notification> optional;
        List<Notification> list;
        long l = System.currentTimeMillis();
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (userAccount == null) {
            throw new ClientMessageException(NotificationServerPlugin.MSG.getMsg("notificationhandler.notloggedin", new Object[0]));
        }
        if (ShutdownManager.isShutDownInProgress()) {
            return null;
        }
        try (ThreadUtils.Semaphore semaphore = ThreadUtils.getSemaphore((Object)userAccount.getID());){
            list = this.o.getNotificationsOfCurrentUser();
            if (!getNotificationsRequestData.isSilentRequest()) {
                this.o.markAllAsRead(l);
            }
        }
        long l2 = list.stream().filter(notification -> notification.isUnread()).count();
        HashMap<GUID, Long> hashMap = getNotificationsRequestData.getCreatedMap();
        ArrayList<Notification> arrayList = new ArrayList<Notification>();
        ArrayList<GUID> arrayList2 = new ArrayList<GUID>();
        list.sort((notification, notification2) -> {
            if (notification.isPermanent() && !notification2.isPermanent()) {
                return -1;
            }
            if (!notification.isPermanent() && notification2.isPermanent()) {
                return 1;
            }
            int n = Long.compare(notification2.getCreated(), notification.getCreated());
            if (n != 0) {
                return n;
            }
            return notification.getId().toString().compareTo(notification2.getId().toString());
        });
        for (Notification notification3 : list) {
            if (arrayList2.size() >= getNotificationsRequestData.getTargetSize()) break;
            arrayList2.add(notification3.getId());
            optional = hashMap.get(notification3.getId());
            if (optional != null && notification3.getCreated() == ((Long)((Object)optional)).longValue()) continue;
            arrayList.add(notification3);
        }
        long l3 = 0L;
        optional = list.stream().max(Comparator.comparing(Notification::getCreated));
        if (optional.isPresent()) {
            l3 = optional.get().getCreated();
        }
        return new GetNotificationResponseData(arrayList2, l2, arrayList, list.size(), l3);
    }

    public /* synthetic */ Object invoke(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (GetNotificationsRequestData)object);
    }
}

