/*
 * Decompiled with CFR 0.152.
 */
package com.inet.notificationui.server.dispatcher;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.cache.shutdown.ShutdownManager;
import com.inet.http.websocket.WebSocketConnectionListener;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.http.websocket.WebsocketConnection;
import com.inet.id.GUID;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.notification.Notification;
import com.inet.notification.NotificationDispatcher;
import com.inet.notification.NotificationGenerator;
import com.inet.notification.NotificationGeneratorCache;
import com.inet.notification.NotificationGroup;
import com.inet.notification.NotificationManager;
import com.inet.notification.NotificationSettings;
import com.inet.notificationui.NotificationServerPlugin;
import com.inet.notificationui.server.data.UnreadNotificationCountResponseData;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceListener;
import com.inet.plugin.ServerPluginManager;
import com.inet.thread.ThreadUtils;
import com.inet.usersandgroups.api.user.BinaryDataKey;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@InternalApi
public class WebNotificationDispatcher
implements NotificationDispatcher {
    private final BinaryDataKey m = new BinaryDataKey("notifications", false, false);

    @Nonnull
    public String getExtensionName() {
        return "notificationdispatcher.web";
    }

    public String getDisplayName() {
        return NotificationServerPlugin.MSG.getMsg("notificationdispatcher.web", new Object[0]);
    }

    public boolean isForWebNotifications() {
        return true;
    }

    public boolean isAvailable() {
        return true;
    }

    public void init() {
        WebSocketEventHandler.getInstance().addConnectionListener(new WebSocketConnectionListener(){

            public void connectionOpened(String pollingID) {
                WebsocketConnection websocketConnection = WebSocketEventHandler.getInstance().getConnection(pollingID);
                if (websocketConnection == null) {
                    return;
                }
                GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
                if (gUID == null) {
                    return;
                }
                if (!ShutdownManager.isShutDownInProgress()) {
                    UnreadNotificationCountResponseData unreadNotificationCountResponseData = WebNotificationDispatcher.this.a(gUID, true);
                    websocketConnection.sendEvent("notification.unreadcount", (Object)unreadNotificationCountResponseData);
                    Persistence.getInstance().sendEvent((Object)new PersistenceUnreadNotificationsEvent(gUID, unreadNotificationCountResponseData));
                }
            }

            public void connectionClosed(String pollingID) {
            }
        });
        Persistence.getInstance().registerListener((PersistenceListener)new a());
    }

    public void generatorDeactivated(NotificationGenerator generator) {
        Set set = WebSocketEventHandler.getInstance().getAllConnectedUserIDs();
        for (GUID gUID : set) {
            UserAccountScope userAccountScope = UserAccountScope.create((GUID)gUID);
            try {
                if (!generator.isForCurrentUser() || ShutdownManager.isShutDownInProgress()) continue;
                UnreadNotificationCountResponseData unreadNotificationCountResponseData = this.a(gUID, true);
                WebSocketEventHandler.getInstance().sendEvent(gUID, () -> new WebSocketEventData("notification.unreadcount", (Object)unreadNotificationCountResponseData));
                Persistence.getInstance().sendEvent((Object)new PersistenceUnreadNotificationsEvent(gUID, unreadNotificationCountResponseData));
            }
            finally {
                if (userAccountScope == null) continue;
                userAccountScope.close();
            }
        }
    }

    public void dispatchNotification(GUID userId, Notification notification, boolean fromGenerator) {
        Object object;
        boolean bl = WebSocketEventHandler.getInstance().getConnectionsForUser(userId).isEmpty();
        if (bl && com.inet.notificationui.server.webpush.a.d().e(userId, notification)) {
            if (fromGenerator) {
                object = NotificationManager.getInstance();
                NotificationGeneratorCache notificationGeneratorCache = object.getNotificationGeneratorCache();
                notificationGeneratorCache.setGeneratorEvaluated(notification.getId(), Set.of(userId), NotificationGeneratorCache.DispatcherType.web);
            }
            if (!notification.isPermanent()) {
                this.deleteNotification(userId, notification.getId());
                return;
            }
        }
        if (fromGenerator && bl) {
            return;
        }
        this.a(userId, notification);
        if (!ShutdownManager.isShutDownInProgress()) {
            object = this.a(userId, false);
            WebSocketEventHandler.getInstance().sendEvent(userId, () -> WebNotificationDispatcher.e((UnreadNotificationCountResponseData)object));
            Persistence.getInstance().sendEvent((Object)new PersistenceUnreadNotificationsEvent(userId, (UnreadNotificationCountResponseData)object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(GUID gUID, Notification notification) {
        try (ThreadUtils.Semaphore semaphore = ThreadUtils.getSemaphore((Object)("WND:" + String.valueOf(gUID)));){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                List<Notification> list = this.a(gUID);
                list.removeIf(notification2 -> notification2.getId().equals((Object)notification.getId()));
                list.add(notification);
                this.a(list, notification.getGroupingKey());
                byte[] byArray = new Json().toJson(list).getBytes(StandardCharsets.UTF_8);
                UserManager.getInstance().storeBinaryData(gUID, this.m, (InputStream)new FastByteArrayInputStream(byArray), byArray.length);
            }
        }
    }

    private UnreadNotificationCountResponseData a(GUID gUID, boolean bl) {
        List<Notification> list = this.b(gUID, bl);
        List list2 = list.stream().filter(notification -> notification.isUnread()).collect(Collectors.toList());
        long l = list2.size();
        boolean bl2 = list2.stream().anyMatch(Notification::isCritical);
        long l2 = list.stream().max(Comparator.comparing(Notification::getCreated)).map(Notification::getCreated).orElse(0L);
        long l3 = list.size();
        if (list.size() > 100) {
            list = list.subList(list.size() - 100, list.size());
        }
        Set<GUID> set = list.stream().map(Notification::getId).collect(Collectors.toSet());
        return new UnreadNotificationCountResponseData(l3, l, bl2, l2, set);
    }

    private void a(List<Notification> list, String string) {
        if (list.size() <= 100) {
            return;
        }
        AtomicInteger atomicInteger = new AtomicInteger(0);
        AtomicInteger atomicInteger2 = new AtomicInteger(0);
        AtomicInteger atomicInteger3 = new AtomicInteger(0);
        List list2 = list.stream().filter(notification -> {
            if (string.equals(notification.getGroupingKey())) {
                if (notification.isPermanent()) {
                    atomicInteger3.incrementAndGet();
                } else if (notification.isCritical()) {
                    atomicInteger2.incrementAndGet();
                } else {
                    atomicInteger.incrementAndGet();
                }
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        for (int j = list2.size(); j > 100; --j) {
            int n = Math.max(atomicInteger3.get(), Math.max(atomicInteger2.get(), atomicInteger.get()));
            Notification notification2 = null;
            if (atomicInteger.get() == n) {
                notification2 = list2.stream().filter(notification -> !notification.isCritical() && !notification.isPermanent()).min(Comparator.comparing(Notification::getCreated)).orElse(null);
                if (notification2 != null) {
                    atomicInteger.decrementAndGet();
                }
            } else if (atomicInteger2.get() == n) {
                notification2 = list2.stream().filter(notification -> notification.isCritical() && !notification.isPermanent()).min(Comparator.comparing(Notification::getCreated)).orElse(null);
                if (notification2 != null) {
                    atomicInteger2.decrementAndGet();
                }
            } else {
                notification2 = list2.stream().filter(notification -> notification.isPermanent()).min(Comparator.comparing(Notification::getCreated)).orElse(null);
                if (notification2 != null) {
                    atomicInteger3.decrementAndGet();
                }
            }
            if (notification2 == null) break;
            list.remove(notification2);
            list2.remove(notification2);
        }
    }

    @Nonnull
    public List<Notification> getNotificationsOfCurrentUser() {
        return this.b(UserManager.getInstance().getCurrentUserAccountID(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private List<Notification> b(GUID gUID, boolean bl) {
        if (gUID == null) {
            return Collections.emptyList();
        }
        try (ThreadUtils.Semaphore semaphore = ThreadUtils.getSemaphore((Object)("WND:" + String.valueOf(gUID)));){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                List<Notification> list = this.a(gUID);
                if (bl) {
                    this.a(gUID, list);
                }
                List<Notification> list2 = list;
                return list2;
            }
        }
    }

    public void deleteNotification(GUID userId, GUID notificationId) {
        ArrayList<GUID> arrayList = new ArrayList<GUID>();
        arrayList.add(notificationId);
        this.deleteNotifications(userId, arrayList);
        if (!ShutdownManager.isShutDownInProgress()) {
            UnreadNotificationCountResponseData unreadNotificationCountResponseData = this.a(userId, false);
            WebSocketEventHandler.getInstance().sendEvent(userId, () -> new WebSocketEventData("notification.unreadcount", (Object)unreadNotificationCountResponseData));
            Persistence.getInstance().sendEvent((Object)new PersistenceUnreadNotificationsEvent(userId, unreadNotificationCountResponseData));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNotifications(GUID userId, List<GUID> toBeDeleted) {
        UserManager userManager = UserManager.getInstance();
        try (Object object = ThreadUtils.getSemaphore((Object)("WND:" + String.valueOf(userId)));){
            ThreadUtils.Semaphore semaphore = object;
            synchronized (semaphore) {
                List<Notification> list = this.a(userId);
                if (!list.isEmpty()) {
                    list.removeIf(notification -> toBeDeleted.contains(notification.getId()));
                    if (list.isEmpty()) {
                        userManager.deleteBinaryData(userId, this.m);
                    } else {
                        byte[] byArray = new Json().toJson(list).getBytes(StandardCharsets.UTF_8);
                        userManager.storeBinaryData(userId, this.m, (InputStream)new FastByteArrayInputStream(byArray), byArray.length);
                    }
                }
            }
        }
        if (!ShutdownManager.isShutDownInProgress()) {
            object = this.a(userId, false);
            WebSocketEventHandler.getInstance().sendEvent(userId, () -> WebNotificationDispatcher.c((UnreadNotificationCountResponseData)object));
            Persistence.getInstance().sendEvent((Object)new PersistenceUnreadNotificationsEvent(userId, (UnreadNotificationCountResponseData)object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsRead(GUID notificationId) {
        UserManager userManager = UserManager.getInstance();
        GUID gUID = userManager.getCurrentUserAccountID();
        if (gUID == null) {
            return;
        }
        try (ThreadUtils.Semaphore semaphore = ThreadUtils.getSemaphore((Object)("WND:" + String.valueOf(gUID)));){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                List<Notification> list = this.a(gUID);
                Stream stream = list.stream();
                stream.filter(notification -> notification.getId().equals((Object)notificationId)).findFirst().ifPresent(notification -> {
                    if (notification.isUnread()) {
                        notification.setUnread(false);
                        byte[] byArray = new Json().toJson((Object)list).getBytes(StandardCharsets.UTF_8);
                        userManager.storeBinaryData(gUID, this.m, (InputStream)new FastByteArrayInputStream(byArray), byArray.length);
                        if (!ShutdownManager.isShutDownInProgress()) {
                            UnreadNotificationCountResponseData unreadNotificationCountResponseData = this.a(gUID, false);
                            WebSocketEventHandler.getInstance().sendEvent(gUID, () -> new WebSocketEventData("notification.unreadcount", (Object)unreadNotificationCountResponseData));
                            Persistence.getInstance().sendEvent((Object)new PersistenceUnreadNotificationsEvent(gUID, unreadNotificationCountResponseData));
                        }
                    }
                });
                stream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAllAsRead(long markUpToTime) {
        UserManager userManager = UserManager.getInstance();
        GUID gUID = userManager.getCurrentUserAccountID();
        if (gUID == null) {
            return;
        }
        try (ThreadUtils.Semaphore semaphore = ThreadUtils.getSemaphore((Object)("WND:" + String.valueOf(gUID)));){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                List<Notification> list = this.a(gUID);
                Stream stream = list.stream();
                AtomicLong atomicLong = new AtomicLong(0L);
                stream.forEach(notification -> {
                    if (notification.isUnread() && (markUpToTime == -1L || markUpToTime >= notification.getCreated())) {
                        notification.setUnread(false);
                        atomicLong.incrementAndGet();
                    }
                });
                stream.close();
                if (atomicLong.get() > 0L) {
                    byte[] byArray = new Json().toJson(list).getBytes(StandardCharsets.UTF_8);
                    userManager.storeBinaryData(gUID, this.m, (InputStream)new FastByteArrayInputStream(byArray), byArray.length);
                    if (!ShutdownManager.isShutDownInProgress()) {
                        UnreadNotificationCountResponseData unreadNotificationCountResponseData = this.a(gUID, false);
                        WebSocketEventHandler.getInstance().sendEvent(gUID, () -> new WebSocketEventData("notification.unreadcount", (Object)unreadNotificationCountResponseData));
                        Persistence.getInstance().sendEvent((Object)new PersistenceUnreadNotificationsEvent(gUID, unreadNotificationCountResponseData));
                    }
                }
            }
        }
    }

    @Nonnull
    private List<Notification> a(GUID gUID) {
        InputStream inputStream = UserManager.getInstance().getBinaryData(gUID, this.m);
        if (inputStream != null) {
            List list;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            try {
                list = (List)new Json().fromJson((Reader)inputStreamReader, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{Notification.class}), new HashMap());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    LogManager.getApplicationLogger().warn((Object)throwable3);
                }
            }
            inputStreamReader.close();
            return list;
        }
        return new ArrayList<Notification>();
    }

    private void a(GUID gUID, List<Notification> list) {
        NotificationManager notificationManager = NotificationManager.getInstance();
        NotificationGeneratorCache notificationGeneratorCache = notificationManager.getNotificationGeneratorCache();
        Set set = notificationManager.getActiveGeneratorIds();
        Set<GUID> set2 = list.stream().filter(notification -> notification.isFromGenerator()).map(Notification::getId).collect(Collectors.toSet());
        set2.forEach(gUID2 -> {
            if (!set.contains(gUID2)) {
                if (notificationGeneratorCache.isUserEvaluatedForGeneratorId(gUID2, gUID, NotificationGeneratorCache.DispatcherType.web)) {
                    return;
                }
                this.deleteNotification(gUID, (GUID)gUID2);
                list.removeIf(notification -> notification.getId().equals(gUID2));
            }
        });
        set.stream().forEach(gUID2 -> {
            NotificationGenerator notificationGenerator = notificationManager.getGenerator(gUID2);
            if (notificationGenerator != null) {
                HashSet<GUID> hashSet = new HashSet<GUID>();
                if (notificationGeneratorCache.isEvaluated(notificationGenerator, gUID, NotificationGeneratorCache.DispatcherType.web)) {
                    return;
                }
                hashSet.add(gUID);
                if (notificationGenerator.isForCurrentUser()) {
                    Notification notification2 = notificationGenerator.createNotification();
                    notification2.setFromGenerator(true);
                    notification2.setId(gUID2);
                    notification2.setGroupingKey(notificationGenerator.getGroupingKey());
                    String string = notification2.getGroupingKey();
                    if (!StringFunctions.isEmpty((String)string)) {
                        Boolean bl;
                        UserAccount userAccount = UserManager.getInstance().getUserAccount(gUID);
                        if (userAccount == null) {
                            return;
                        }
                        NotificationSettings notificationSettings = com.inet.notificationui.server.a.a(userAccount);
                        Map map = notificationSettings.getActiveStatesMap();
                        HashMap hashMap = (HashMap)map.get(string);
                        if (hashMap == null) {
                            hashMap = new HashMap();
                        }
                        if ((bl = (Boolean)hashMap.get(this.getExtensionName())) == null) {
                            NotificationGroup notificationGroup = null;
                            try {
                                notificationGroup = (NotificationGroup)ServerPluginManager.getInstance().getSingleInstanceByName(NotificationGroup.class, string, false);
                            }
                            catch (IllegalStateException illegalStateException) {
                                // empty catch block
                            }
                            bl = notificationGroup != null ? Boolean.valueOf(notificationGroup.isDefaultActiveForWebnotifications()) : Boolean.TRUE;
                        }
                        if (!bl.booleanValue()) {
                            return;
                        }
                    }
                    list.removeIf(notification -> notification.getId().equals(gUID2));
                    list.add(notification2);
                    this.a(gUID, notification2);
                }
                if (!hashSet.isEmpty()) {
                    notificationGeneratorCache.setGeneratorEvaluated(gUID2, hashSet, NotificationGeneratorCache.DispatcherType.web);
                }
            }
        });
    }

    private static /* synthetic */ WebSocketEventData c(UnreadNotificationCountResponseData unreadNotificationCountResponseData) {
        return new WebSocketEventData("notification.unreadcount", (Object)unreadNotificationCountResponseData);
    }

    private static /* synthetic */ WebSocketEventData e(UnreadNotificationCountResponseData unreadNotificationCountResponseData) {
        return new WebSocketEventData("notification.unreadcount", (Object)unreadNotificationCountResponseData);
    }

    private class a
    implements PersistenceListener<PersistenceUnreadNotificationsEvent> {
        private a() {
        }

        public void a(@Nonnull PersistenceUnreadNotificationsEvent persistenceUnreadNotificationsEvent) {
            GUID gUID = persistenceUnreadNotificationsEvent.userId;
            UnreadNotificationCountResponseData unreadNotificationCountResponseData = persistenceUnreadNotificationsEvent.notificationCountData;
            WebSocketEventHandler.getInstance().sendEvent(gUID, () -> new WebSocketEventData("notification.unreadcount", (Object)unreadNotificationCountResponseData));
        }

        public /* synthetic */ void eventReceived(@Nonnull Object object) {
            this.a((PersistenceUnreadNotificationsEvent)object);
        }
    }

    @JsonData
    private static class PersistenceUnreadNotificationsEvent {
        private GUID userId;
        private UnreadNotificationCountResponseData notificationCountData;

        PersistenceUnreadNotificationsEvent() {
        }

        public PersistenceUnreadNotificationsEvent(GUID userId, UnreadNotificationCountResponseData notificationCountData) {
            this.userId = userId;
            this.notificationCountData = notificationCountData;
        }
    }
}

