/*
 * Decompiled with CFR 0.152.
 */
package com.inet.notificationui.server;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.util.StringFunctions;
import com.inet.notification.Times;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.annotation.Nullable;

@JsonData
@InternalApi
public class NotificationTime {
    private TimeRange timeRange = null;
    private DateRange dateRange = null;
    private ArrayList<DayOfWeek> weekdays = new ArrayList<DayOfWeek>(){
        {
            this.add(DayOfWeek.MONDAY);
            this.add(DayOfWeek.TUESDAY);
            this.add(DayOfWeek.WEDNESDAY);
            this.add(DayOfWeek.THURSDAY);
            this.add(DayOfWeek.FRIDAY);
            this.add(DayOfWeek.SATURDAY);
            this.add(DayOfWeek.SUNDAY);
        }
    };

    public NotificationTime() {
    }

    public NotificationTime(DateRange dateRange) {
        this.dateRange = dateRange;
    }

    public void setTimeRange(TimeRange timeRange) {
        this.timeRange = timeRange;
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    public void setDateRange(DateRange dateRange) {
        this.dateRange = dateRange;
    }

    public DateRange getDateRange() {
        return this.dateRange;
    }

    public void setWeekdays(ArrayList<DayOfWeek> weekdays) {
        this.weekdays = weekdays;
    }

    public Times getNextTimes() {
        return this.getNextTimes(LocalDateTime.now());
    }

    protected Times getNextTimes(LocalDateTime currentDateTime) {
        LocalDateTime localDateTime;
        if (this.weekdays == null || this.weekdays.isEmpty()) {
            return new Times(-1L, -1L);
        }
        LocalDate localDate = currentDateTime.toLocalDate();
        LocalDate localDate2 = LocalDate.MIN;
        LocalDate localDate3 = LocalDate.MAX;
        if (this.dateRange != null) {
            if (this.dateRange.getStartDate() != null) {
                localDate2 = Instant.ofEpochSecond(this.dateRange.getStartDate()).atZone(ZoneId.systemDefault().normalized()).toLocalDate();
            }
            if (this.dateRange.getEndDate() != null) {
                localDate3 = Instant.ofEpochSecond(this.dateRange.getEndDate()).atZone(ZoneId.systemDefault().normalized()).toLocalDate();
            }
        }
        LocalTime localTime = LocalTime.MIN;
        LocalTime localTime2 = LocalTime.MAX;
        if (this.timeRange != null) {
            if (this.timeRange.getStartTime() != null) {
                localTime = LocalTime.ofSecondOfDay(this.timeRange.getStartTime());
            }
            if (this.timeRange.getEndTime() != null) {
                localTime2 = LocalTime.ofSecondOfDay(this.timeRange.getEndTime());
            }
        }
        boolean bl = true;
        if (localDate.isBefore(localDate2)) {
            bl = false;
        }
        if (bl && localDate.isAfter(localDate3)) {
            bl = false;
        }
        if (bl && this.weekdays != null && !this.weekdays.contains(localDate.getDayOfWeek())) {
            bl = false;
        }
        LocalDateTime localDateTime2 = LocalDateTime.of(localDate, localTime);
        LocalDateTime localDateTime3 = LocalDateTime.of(localDate, localTime2);
        if (bl) {
            if (localTime2.isAfter(localTime) || localTime2.equals(localTime)) {
                if (currentDateTime.isBefore(localDateTime2)) {
                    bl = false;
                }
                if (bl && currentDateTime.isAfter(localDateTime3)) {
                    bl = false;
                }
            } else {
                if (currentDateTime.isAfter(localDateTime3)) {
                    localDateTime3 = localDateTime3.plusDays(1L);
                    if (currentDateTime.isBefore(localDateTime2)) {
                        bl = false;
                    }
                }
                if (currentDateTime.isBefore(localDateTime2)) {
                    localDateTime2 = localDateTime2.minusDays(1L);
                }
            }
        }
        if (bl) {
            return new Times(localDateTime2.atZone(ZoneId.systemDefault().normalized()).toInstant().toEpochMilli(), localDateTime3.atZone(ZoneId.systemDefault().normalized()).toInstant().toEpochMilli());
        }
        localDateTime2 = LocalDateTime.of(localDate, localTime);
        localDateTime3 = LocalDateTime.of(localDate, localTime2);
        if (localDateTime3.isBefore(localDateTime2)) {
            localDateTime3 = localDateTime3.plusDays(1L);
        }
        if (currentDateTime.isAfter(localDateTime3)) {
            localDateTime2 = localDateTime2.plusDays(1L);
        }
        if (localDate2.isAfter(localDateTime2.toLocalDate())) {
            localDateTime2 = LocalDateTime.of(localDate2, localDateTime2.toLocalTime());
        }
        if (this.weekdays != null && !this.weekdays.isEmpty()) {
            while (!this.weekdays.contains(localDateTime2.getDayOfWeek())) {
                localDateTime2 = localDateTime2.plusDays(1L);
            }
        }
        if (localDateTime2.isAfter(localDateTime = LocalDateTime.of(localDate3, localTime2))) {
            return new Times(-1L, -1L);
        }
        localDateTime3 = LocalDateTime.of(localDateTime2.toLocalDate(), localTime2);
        if (localDateTime3.isBefore(localDateTime2)) {
            localDateTime3 = localDateTime3.plusDays(1L);
        }
        return new Times(localDateTime2.atZone(ZoneId.systemDefault().normalized()).toInstant().toEpochMilli(), localDateTime3.atZone(ZoneId.systemDefault().normalized()).toInstant().toEpochMilli());
    }

    public ArrayList<DayOfWeek> getWeekday() {
        return this.weekdays;
    }

    @JsonData
    public static final class TimeRange {
        private Long startTime = null;
        private Long endTime = null;

        private TimeRange() {
        }

        public TimeRange(@Nullable Long startTime, @Nullable Long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        @Nullable
        public Long getStartTime() {
            return this.startTime;
        }

        @Nullable
        public Long getEndTime() {
            return this.endTime;
        }
    }

    @JsonData
    public static final class DateRange {
        private Long startDate = null;
        private Long endDate = null;

        private DateRange() {
        }

        public DateRange(@Nullable Long startDate, @Nullable Long endDate) {
            this.startDate = startDate;
            this.endDate = endDate;
        }

        @Nullable
        public Long getStartDate() {
            return this.startDate;
        }

        @Nullable
        public Long getEndDate() {
            return this.endDate;
        }
    }

    @JsonData
    public static final class DateRangeDescription {
        private String startDate = null;
        private String endDate = null;

        private DateRangeDescription() {
        }

        public DateRangeDescription(@Nullable String startDate, @Nullable String endDate) {
            this.startDate = startDate;
            this.endDate = endDate;
        }

        @Nullable
        public String getStartDate() {
            return this.startDate;
        }

        @Nullable
        public String getEndDate() {
            return this.endDate;
        }

        public static String toDate(Long date) {
            if (date == null) {
                return null;
            }
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(DateRangeDescription.getExtendedDatePattern());
            LocalDate localDate = Instant.ofEpochSecond(date).atZone(ZoneId.systemDefault().normalized()).toLocalDate();
            return dateTimeFormatter.format(localDate);
        }

        public static Long parseDate(String date) {
            if (StringFunctions.isEmpty((String)date)) {
                return null;
            }
            LocalDate localDate = null;
            try {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(DateRangeDescription.getExtendedDatePattern());
                localDate = LocalDate.parse(date, dateTimeFormatter);
                return localDate.atStartOfDay(ZoneId.systemDefault().normalized()).toEpochSecond();
            }
            catch (Exception exception) {
                try {
                    DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(DateRangeDescription.getShortDatePattern());
                    localDate = LocalDate.parse(date, dateTimeFormatter);
                    return localDate.atStartOfDay(ZoneId.systemDefault().normalized()).toEpochSecond();
                }
                catch (Exception exception2) {
                    return null;
                }
            }
        }

        public static String getExtendedDatePattern() {
            return ((SimpleDateFormat)SimpleDateFormat.getDateInstance(3, ClientLocale.getThreadLocale())).toPattern().replaceAll("d+", "dd").replaceAll("M+", "MM").replaceAll("y+", "yyyy");
        }

        public static String getShortDatePattern() {
            return ((SimpleDateFormat)SimpleDateFormat.getDateInstance(3, ClientLocale.getThreadLocale())).toPattern();
        }
    }
}

