/*
 * Decompiled with CFR 0.152.
 */
package com.inet.notificationui.structure;

import com.inet.config.ConfigKey;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.StyledLabelConfigProperty;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.StringFunctions;
import com.inet.notificationui.NotificationServerPlugin;
import com.inet.notificationui.server.NotificationTime;
import com.inet.notificationui.server.UserDefinedNotificationGenerator;
import com.inet.notificationui.server.webpush.a;
import com.inet.notificationui.structure.NotificationConfigProperty;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.ui.TargetValue;
import java.lang.reflect.Type;
import java.net.URL;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class b
extends AbstractStructureProvider {
    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        groups.add(this.getCommunicationGroup(settings));
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (groupKey) {
            case "categorygroup.communication": {
                if (!ServerPluginManager.getInstance().isPluginLoaded("usersandgroupsmanager") || !SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER)) break;
                categories.add(new ConfigCategory(210, "category.notification", this.translate(settings, "category.notification", new Object[0]), "components-notification"));
                break;
            }
        }
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        switch (categoryKey) {
            case "category.notification": {
                return ((Object)((Object)this)).getClass().getResource("notification_48.png");
            }
        }
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> configPropertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        if ("category.notification".equals(categoryKey)) {
            configPropertyGroups.add(new ConfigPropertyGroup(100, "group.notification"));
            if (advanced) {
                configPropertyGroups.add(new ConfigPropertyGroup(200, "group.webpush", this.translate(settings, "group.webpush", new Object[0])));
            }
        }
    }

    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "group.notification": {
                configProperties.add((ConfigProperty)new NotificationConfigProperty(this, settings));
                break;
            }
            case "group.webpush": {
                String string = String.join((CharSequence)"\n", "android.googleapis.com;fcm.googleapis.com;updates.push.services.mozilla.com;updates-autopush.stage.mozaws.net;updates-autopush.dev.mozaws.net;.notify.windows.com;.push.apple.com".split(";"));
                configProperties.add((ConfigProperty)new StyledLabelConfigProperty(Set.of(StyledLabelConfigProperty.Style.pre), 0, "webpush.whitelist.hint", this.translate(settings, "webpush.whitelist.hint", new Object[0]), string));
                ConfigKey configKey = a.v;
                ConfigAction[] configActionArray = new ConfigAction[]{new ConfigAction(this.translate(settings, configKey.getKey() + ".add", new Object[0]))};
                ConfigProperty configProperty = new ConfigProperty(0, "", "SimpleText", null, null, null, this.translate(settings, configKey.getKey() + ".placeholder", new Object[0]));
                List list = (List)new Json().fromJson(settings.getValue(configKey), (Type)new JsonParameterizedType(List.class, new Type[]{String[].class}));
                this.addTableTo(configProperties, configKey, "SimpleText", settings, list, configActionArray, new ConfigProperty[]{configProperty});
            }
        }
    }

    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> validationMessages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
        if ("notificationtemplate.add".equals(categoryKey)) {
            Properties properties = settings.getValues();
            Set<Object> set = properties.keySet();
            block14: for (Object object : set) {
                String string = (String)object;
                String string2 = (String)properties.get(object);
                switch (string) {
                    case "title": {
                        if (StringFunctions.isEmpty((String)string2)) break;
                        HashMap hashMap = (HashMap)new Json().fromJson(string2, (Type)new JsonParameterizedType(HashMap.class, new Type[]{String.class, String.class}));
                        if (hashMap.get("default") != null) continue block14;
                        validationMessages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "notificationtemplate.noemptydefaulttitle", new Object[0]), string));
                        break;
                    }
                    case "message": {
                        if (StringFunctions.isEmpty((String)string2)) break;
                        HashMap hashMap = (HashMap)new Json().fromJson(string2, (Type)new JsonParameterizedType(HashMap.class, new Type[]{String.class, String.class}));
                        if (hashMap.get("default") != null) continue block14;
                        validationMessages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "notificationtemplate.noemptydefaultmessage", new Object[0]), string));
                        break;
                    }
                    case "targets": {
                        Object object2;
                        int n = 0;
                        if (string2.length() > 0) {
                            object2 = TargetValue.getReceivers((String)string2);
                            for (Map.Entry entry : object2.entrySet()) {
                                n += ((Set)entry.getValue()).size();
                            }
                        }
                        if (n != 0) break;
                        validationMessages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "notificationtemplate.targets.mustbeset", new Object[0]), string));
                        break;
                    }
                    case "notificationWeekDays": {
                        if (StringFunctions.isEmpty((String)string2)) break;
                        Object object2 = (ArrayList)new Json().fromJson(string2, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{DayOfWeek.class}));
                        if (object2 == null || !((ArrayList)object2).isEmpty()) continue block14;
                        validationMessages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "notificationtemplate.weekdays.isempty", new Object[0]), string));
                        break;
                    }
                    case "notificationDateRange": {
                        if (StringFunctions.isEmpty((String)string2)) break;
                        Object object2 = (NotificationTime.DateRangeDescription)new Json().fromJson(string2, NotificationTime.DateRangeDescription.class);
                        if (object2 == null) continue block14;
                        Long l = NotificationTime.DateRangeDescription.parseDate(((NotificationTime.DateRangeDescription)object2).getStartDate());
                        Long l2 = NotificationTime.DateRangeDescription.parseDate(((NotificationTime.DateRangeDescription)object2).getEndDate());
                        if (l == null && !StringFunctions.isEmpty((String)((NotificationTime.DateRangeDescription)object2).getStartDate())) {
                            validationMessages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "notificationtemplate.date.startinvalid", new Object[0]), string));
                        }
                        if (l2 == null && !StringFunctions.isEmpty((String)((NotificationTime.DateRangeDescription)object2).getEndDate())) {
                            validationMessages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "notificationtemplate.date.endinvalid", new Object[0]), string));
                        }
                        if (l == null || l2 == null || l <= l2) continue block14;
                        validationMessages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "notificationtemplate.date.startafterend", new Object[0]), string));
                        break;
                    }
                }
            }
        }
    }

    public ConfigStructure.SaveState save(String key, String value, @Nonnull ConfigStructureSettings settings) {
        switch (key) {
            case "UserdefinedNotificationGenerators": {
                ArrayList<UserDefinedNotificationGenerator> arrayList = new ArrayList<UserDefinedNotificationGenerator>();
                String string = settings.getValue(NotificationServerPlugin.USERDEFINED_NOTIFICATION_GENERATORS.getKey());
                Json json = new Json();
                if (!StringFunctions.isEmpty((String)string)) {
                    ArrayList arrayList2 = (ArrayList)json.fromJson(string, ArrayList.class, new Type[]{HashMap.class});
                    for (HashMap hashMap : arrayList2) {
                        UserDefinedNotificationGenerator userDefinedNotificationGenerator = NotificationConfigProperty.mapToTemplate(hashMap);
                        if (userDefinedNotificationGenerator.getId() == null) {
                            userDefinedNotificationGenerator.setId(GUID.generateNew());
                        }
                        arrayList.add(userDefinedNotificationGenerator);
                    }
                }
                settings.save(NotificationServerPlugin.USERDEFINED_NOTIFICATION_GENERATORS, json.toJson(arrayList));
                return ConfigStructure.SaveState.SAVE;
            }
        }
        return ConfigStructure.SaveState.NONE;
    }
}

