/*
 * Decompiled with CFR 0.152.
 */
package com.inet.notificationui.server.webpush;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.notification.Notification;
import com.inet.notification.NotificationSettings;
import com.inet.notification.WebPushSubscription;
import com.inet.notificationui.server.webpush.WebPushKeyPair;
import com.inet.notificationui.server.webpush.b;
import com.inet.notificationui.server.webpush.d;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;
import javax.net.ssl.HttpsURLConnection;

public class a {
    public static final ConfigKey v = new ConfigKey("webpush.services", "[]", List.class);
    private static final ConfigValue<Set<String>> w = new ConfigValue<Set<String>>(v){

        protected Set<String> a(String string) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(Arrays.asList("android.googleapis.com;fcm.googleapis.com;updates.push.services.mozilla.com;updates-autopush.stage.mozaws.net;updates-autopush.dev.mozaws.net;.notify.windows.com;.push.apple.com".split(";")));
            List list = (List)new Json().fromJson(string, (Type)new JsonParameterizedType(List.class, new Type[]{String[].class}));
            for (String[] stringArray : list) {
                hashSet.add(stringArray[0]);
            }
            return hashSet;
        }

        protected /* synthetic */ Object convert(String string) throws IllegalArgumentException {
            return this.a(string);
        }
    };
    private static final ConfigKey x = new ConfigKey("webpush.keypair", null, WebPushKeyPair.class);
    private static final ConfigValue<WebPushKeyPair> y = new ConfigValue(x);
    private static final a z = new a();

    public static a d() {
        return z;
    }

    @Nonnull
    private WebPushKeyPair e() {
        WebPushKeyPair webPushKeyPair = (WebPushKeyPair)y.get();
        if (webPushKeyPair == null) {
            webPushKeyPair = WebPushKeyPair.generate();
            ConfigurationManager.getInstance().getCurrent().put(x, new Json().toJson((Object)webPushKeyPair));
            webPushKeyPair = (WebPushKeyPair)y.get();
        }
        return webPushKeyPair;
    }

    @Nonnull
    public String getApplicationServerKey() {
        return this.e().getApplicationServerKey();
    }

    @SuppressFBWarnings(value={"TRUST_BOUNDARY_VIOLATION"}, justification="Only trusted services acepted")
    public void a(GUID gUID, WebPushSubscription webPushSubscription2) {
        HttpSession httpSession;
        if (webPushSubscription2 == null || !webPushSubscription2.isValid()) {
            LogManager.getApplicationLogger().warn((Object)"Web Push subscription is invalid");
            return;
        }
        if (!this.a(webPushSubscription2)) {
            return;
        }
        UserAccount userAccount = UserManager.getInstance().getUserAccount(gUID);
        if (userAccount == null || userAccount.getAccountType() == UserAccountType.Guest) {
            return;
        }
        NotificationSettings notificationSettings = com.inet.notificationui.server.a.a(userAccount);
        String string = webPushSubscription2.getEndpoint();
        List list = notificationSettings.getSubscriptions();
        if (!list.contains(webPushSubscription2)) {
            list.removeIf(webPushSubscription -> webPushSubscription.getEndpoint().equals(string));
            list.add(0, webPushSubscription2);
            com.inet.notificationui.server.a.a(userAccount, notificationSettings);
            LogManager.getApplicationLogger().info((Object)("Web Push subscription added for " + userAccount.getDisplayName()));
        }
        if ((httpSession = SessionStore.getHttpSession()) != null) {
            httpSession.setAttribute("webpush.endpoint", (Object)string);
        }
    }

    public boolean e(GUID gUID, Notification notification) {
        return this.a(gUID, notification, 604800, notification.isCritical() ? d.Q : d.P);
    }

    public boolean a(GUID gUID, Notification notification, int n, d d2) {
        UserAccount userAccount = UserManager.getInstance().getUserAccount(gUID);
        if (userAccount == null) {
            return false;
        }
        NotificationSettings notificationSettings = com.inet.notificationui.server.a.a(userAccount, false);
        if (notificationSettings == null) {
            return false;
        }
        String string = new Json().toJson((Object)notification);
        String string2 = ("0000000" + notification.getId().toString()).substring(0, 32);
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = notificationSettings.getSubscriptions().iterator();
        block9: while (iterator.hasNext()) {
            WebPushSubscription webPushSubscription = (WebPushSubscription)iterator.next();
            try {
                if (!this.a(webPushSubscription)) {
                    iterator.remove();
                    bl = true;
                    continue;
                }
                block10: while (true) {
                    HttpsURLConnection httpsURLConnection = this.a(string, string2, webPushSubscription, n, d2);
                    int n2 = httpsURLConnection.getResponseCode();
                    switch (n2) {
                        case 201: {
                            bl2 = true;
                            break block10;
                        }
                        case 403: 
                        case 404: 
                        case 410: {
                            iterator.remove();
                            bl = true;
                            break block10;
                        }
                        case 406: {
                            bl2 |= this.a(httpsURLConnection, string, string2, webPushSubscription, 604800, d.P);
                        }
                        default: {
                            InputStream inputStream;
                            try {
                                inputStream = httpsURLConnection.getInputStream();
                            }
                            catch (Exception exception) {
                                inputStream = httpsURLConnection.getErrorStream();
                            }
                            String string3 = inputStream != null ? IOFunctions.readAsciiString((InputStream)inputStream) : "";
                            LogManager.getApplicationLogger().warn((Object)("Web Push endpoint responded with status code: " + n2 + "\n\tendpoint: " + webPushSubscription.getEndpoint() + "\n\tresponse: " + string3 + "\n\tuserid: " + String.valueOf(gUID) + "\n\theaders: " + String.valueOf(httpsURLConnection.getHeaderFields()) + "\n\ttopic: " + string2));
                            if (!string3.contains("BadWebPushTopic") || string2 == null) continue block9;
                            string2 = null;
                            continue block10;
                        }
                    }
                    break;
                }
            }
            catch (Exception exception) {
                LogManager.getApplicationLogger().warn((Object)("Web Push endpoint not reachable: " + String.valueOf(exception) + "\n\tendpoint: " + webPushSubscription.getEndpoint() + "\n\tuserid: " + String.valueOf(gUID)));
                LogManager.getApplicationLogger().debug((Object)exception);
            }
        }
        if (bl) {
            com.inet.notificationui.server.a.a(userAccount, notificationSettings);
        }
        return bl2;
    }

    private boolean a(HttpsURLConnection httpsURLConnection, final String string, final String string2, final WebPushSubscription webPushSubscription, final int n, final d d2) {
        try {
            final int n2 = Integer.valueOf(httpsURLConnection.getHeaderField("Retry-After"));
            if (n2 <= 0 || n - n2 <= 0) {
                return false;
            }
            DefaultTimerTask defaultTimerTask = new DefaultTimerTask(){

                public void runImpl() throws Throwable {
                    int n3 = n - n2;
                    HttpsURLConnection httpsURLConnection = a.this.a(string, string2, webPushSubscription, n3, d2);
                    int n22 = httpsURLConnection.getResponseCode();
                    if (n22 == 406) {
                        a.this.a(httpsURLConnection, string, string2, webPushSubscription, n3, d2);
                    }
                }
            };
            DefaultTimer.getInstance().schedule(defaultTimerTask, (long)(n2 * 1000));
            return true;
        }
        catch (Exception exception) {
            LogManager.getApplicationLogger().warn((Object)exception);
            return false;
        }
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Only known Web Push services are accepted")
    HttpsURLConnection a(String string, String string2, WebPushSubscription webPushSubscription, int n, d d2) throws IOException {
        URL uRL = new URL(webPushSubscription.getEndpoint());
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
        if (n < 0) {
            n = 0;
        }
        httpsURLConnection.setRequestProperty("TTL", Integer.toString(n));
        if (d2 != null) {
            httpsURLConnection.setRequestProperty("Urgency", d2.f());
        }
        if (string2 != null) {
            httpsURLConnection.setRequestProperty("Topic", string2);
        }
        String string3 = b.a(uRL, this.e().getPrivateKey());
        String string4 = "vapid t=" + string3 + ", k=" + Base64.getUrlEncoder().withoutPadding().encodeToString(b.a(this.e().getPublicKey()));
        httpsURLConnection.setRequestProperty("Authorization", string4);
        httpsURLConnection.setRequestMethod("POST");
        if (!StringFunctions.isEmpty((String)string)) {
            httpsURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
            httpsURLConnection.setRequestProperty("Content-Encoding", "aes128gcm");
            httpsURLConnection.setDoOutput(true);
            try (OutputStream outputStream = httpsURLConnection.getOutputStream();){
                outputStream.write(b.a(string, webPushSubscription.getP256dh(), webPushSubscription.getAuth()));
            }
        }
        httpsURLConnection.getResponseCode();
        return httpsURLConnection;
    }

    private boolean a(@Nonnull WebPushSubscription webPushSubscription) {
        String string = webPushSubscription.getEndpoint();
        try {
            string = new URL(string).getHost();
            for (String string2 : (Set)w.get()) {
                if (!string.endsWith(string2)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LogManager.getApplicationLogger().warn((Object)("Unknown Web Push service: '" + string + "'. Add the hostname to the trusted Web Push services in the configuration manager."));
        return false;
    }
}

