/*
 * Decompiled with CFR 0.152.
 */
package com.inet.maintenance.api.cache;

import com.inet.annotations.JsonData;
import com.inet.http.ClientMessageException;
import com.inet.maintenance.InetMaintenanceServerPlugin;
import javax.annotation.Nonnull;

@JsonData
public abstract class MaintenanceCacheAction {
    private String id;
    private String title;
    private boolean enabled;

    private MaintenanceCacheAction() {
    }

    public MaintenanceCacheAction(String cacheActionId) {
        this.id = cacheActionId;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean cacheActionEnabled) {
        this.enabled = cacheActionEnabled;
    }

    public void setTitle(String cacheActionTitle) {
        this.title = cacheActionTitle;
    }

    public void setDefaultState(boolean cacheActionEnabled) {
        if (cacheActionEnabled) {
            this.setEnabled(false);
            this.setTitle(InetMaintenanceServerPlugin.MSG.getMsg("usersAndGroupsCacheAction.title.running", new Object[0]));
        } else {
            this.setEnabled(true);
            this.setTitle(InetMaintenanceServerPlugin.MSG.getMsg("usersAndGroupsCacheAction.title.enabled", new Object[0]));
        }
    }

    public abstract void updateAction();

    public abstract String executeAction() throws ClientMessageException;

    @Nonnull
    public static String getDefaultExecuteActionMessage() {
        return InetMaintenanceServerPlugin.MSG.getMsg("actionresult.indexerstarted", new Object[0]);
    }
}

