/*
 * Decompiled with CFR 0.152.
 */
package com.inet.maintenance.server.useraccounts;

import com.inet.annotations.JsonData;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.maintenance.api.usercleanup.User;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.SearchTag;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SearchID;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.user.search.SearchTagLocked;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class UserCleanupUtils {
    public static Ranges v() {
        Iterator iterator;
        UserManager userManager = UserManager.getRecoveryEnabledInstance();
        SearchTag searchTag = userManager.getSearchEngine().getTag("lastaccess");
        Ranges ranges = new Ranges();
        ranges.count = userManager.getIndexCount() - UserCleanupUtils.w();
        ranges.minDate = System.currentTimeMillis();
        ranges.maxDate = System.currentTimeMillis();
        if (ranges.count != 0L && searchTag != null) {
            Object object;
            Object object2 = userManager.getSearchEngine().getMinToken(searchTag);
            if (object2 != null && object2 instanceof Long) {
                ranges.minDate = (Long)object2;
            }
            if ((object = userManager.getSearchEngine().getMaxToken(searchTag)) != null && object instanceof Long) {
                ranges.maxDate = (Long)object;
            }
        }
        ranges.dates = new Range[100];
        int n = 0;
        long l2 = ranges.minDate;
        if (ranges.minDate == 0L && searchTag != null && (iterator = userManager.getSearchEngine().createValuesIterator(searchTag, true)).hasNext()) {
            iterator.next();
            if (iterator.hasNext()) {
                l2 = (Long)iterator.next() - 86400000L;
                n = 1;
                ranges.dates[0] = new Range(0L, l2);
            }
        }
        double d2 = (double)(ranges.maxDate - l2) / (double)(ranges.dates.length - n);
        long l3 = l2 - 1L;
        for (int i2 = n; i2 < ranges.dates.length; ++i2) {
            long l4 = l3 + 1L;
            l3 = Math.round((double)l2 + d2 * (double)(i2 + 1 - n));
            ranges.dates[i2] = new Range(l4, l3);
        }
        return ranges;
    }

    public static int w() {
        SearchCondition searchCondition = new SearchCondition("useraccounttype", SearchCondition.SearchTermOperator.Equals, (Object)UserAccountType.Temp.name());
        Set set = UserManager.getRecoveryEnabledInstance().getSearchEngine().simpleSearch(new SearchCommand(new SearchExpression[]{searchCondition}));
        return set.size();
    }

    public static List<User> b(List<SearchResultEntry<GUID>> list) {
        ArrayList<User> arrayList = new ArrayList<User>(list.size());
        UserManager userManager = UserManager.getRecoveryEnabledInstance();
        for (SearchResultEntry<GUID> searchResultEntry : list) {
            GUID gUID = (GUID)searchResultEntry.getId();
            UserAccount userAccount = userManager.getUserAccount(gUID);
            if (userAccount == null) continue;
            long l2 = userManager.getAccountFileSize(gUID);
            arrayList.add(new User(gUID, userAccount.getDisplayName(), userAccount.getLastAccess(), l2, (String)userAccount.getValue((UserField)UsersAndGroups.FIELD_USER_LOCKED), userAccount.isActive()));
        }
        return arrayList;
    }

    public static SearchResult<GUID> a(UserManager userManager, String string, long l2, long l3, boolean bl) {
        ArrayList<SearchCondition> arrayList = new ArrayList<SearchCondition>();
        arrayList.add(new SearchCondition("useraccounttype", SearchCondition.SearchTermOperator.Unequals, (Object)UserAccountType.Temp.name()));
        arrayList.add(new SearchCondition("lastaccess", SearchCondition.SearchTermOperator.BETWEEN, (Object)new Object[]{l2, l3}));
        if (!bl) {
            arrayList.add(new SearchCondition("locked", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagLocked.valueAsInt((boolean)false)));
        }
        TextSearchCommandBuilder textSearchCommandBuilder = new TextSearchCommandBuilder(userManager.getSearchEngine(), string);
        SearchCommand searchCommand = textSearchCommandBuilder.build();
        searchCommand.getSearchExpression().addAll(arrayList);
        HttpSession httpSession = SessionStore.getHttpSession((boolean)false);
        SearchID searchID = httpSession == null ? null : new SearchID((Object)("maintenance_" + httpSession.getId()));
        SearchResult searchResult = userManager.search(string, arrayList, Collections.emptyList(), 10000, searchID);
        return searchResult;
    }

    @JsonData
    public static final class Ranges {
        private long minDate = Long.MAX_VALUE;
        private long maxDate = 0L;
        private long count = 0L;
        private Range[] dates = null;

        public long getCount() {
            return this.count;
        }

        public Range[] getDates() {
            return this.dates;
        }

        public long getMaxDate() {
            return this.maxDate;
        }

        public long getMinDate() {
            return this.minDate;
        }
    }

    @JsonData
    public static final class Range {
        private long start = 0L;
        private long end = 0L;

        private Range() {
        }

        public Range(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public String toString() {
            return "Start:" + this.start + ", End:" + this.end;
        }
    }
}

