/*
 * Decompiled with CFR 0.152.
 */
package com.inet.maintenance.server.backup.webapi.definitions;

import com.inet.maintenance.InetMaintenanceServerPlugin;
import com.inet.maintenance.api.backup.BackupDefinition;
import com.inet.maintenance.api.backup.BackupJob;
import com.inet.maintenance.server.backup.a;
import com.inet.maintenance.server.backup.webapi.model.BackupListResponse;
import com.inet.maintenance.server.backup.webapi.results.b;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Tag(name="Backup", description="Backup results operations")
public class d
extends RequestHandler.WithParentPathToken<Void, Void, UUID> {
    public d() {
        super(new String[]{"results"});
        this.setGenericRequestHandler((RequestHandler)new b());
    }

    @Operation(summary="List backup results for definition", description="Lists all backup jobs and their results for a specific backup definition", responses={@ApiResponse(responseCode="200", description="List of backup jobs retrieved successfully", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=BackupListResponse.class)))}), @ApiResponse(responseCode="404", description="Backup definition not found or no results available")})
    public Void a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Void void_, @Nullable UUID uUID, boolean bl) throws IOException {
        BackupDefinition backupDefinition = a.b(uUID);
        if (backupDefinition == null) {
            ResponseWriter.notFound((HttpServletResponse)httpServletResponse);
            return null;
        }
        List<BackupJob> list = a.h();
        list.removeIf(backupJob -> !backupJob.getDefinitionId().equals(backupDefinition.getId()));
        if (list.isEmpty()) {
            ResponseWriter.notFound((HttpServletResponse)httpServletResponse, (String)InetMaintenanceServerPlugin.MSG.getMsg("job.backup.status.notfound", new Object[0]));
        }
        List list2 = list.stream().map(backupJob -> BackupListResponse.from(backupJob)).collect(Collectors.toList());
        ResponseWriter.json((HttpServletResponse)httpServletResponse, list2);
        return null;
    }

    public String getHelpPageKey() {
        return "maintenance.backup.api.resultlist";
    }

    @Operation(summary="List backup results for definition", description="Lists all backup jobs and their results for a specific backup definition", responses={@ApiResponse(responseCode="200", description="List of backup jobs retrieved successfully", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=BackupListResponse.class)))}), @ApiResponse(responseCode="404", description="Backup definition not found or no results available")})
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Object object, @Nullable Object object2, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (Void)object, (UUID)object2, bl);
    }
}

