/*
 * Decompiled with CFR 0.152.
 */
package com.inet.maintenance.server.cache;

import com.inet.annotations.JsonData;
import com.inet.http.ClientMessageException;
import com.inet.maintenance.api.cache.MaintenanceCacheAction;
import com.inet.search.index.IndexerStatus;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.AuthGroupManager;
import com.inet.usersandgroups.api.user.UserManager;

@JsonData
public class UsersAndGroupsCacheAction
extends MaintenanceCacheAction {
    static final int INDEXER_COUNT_NOT_AVAILABLE = -1;
    private IndexerStatus currentUserManagerIndexerStatus = new IndexerStatus(false, 0L, -1L, 0L);
    private IndexerStatus currentUserGroupsManagerIndexerStatus = new IndexerStatus(false, 0L, -1L, 0L);

    public UsersAndGroupsCacheAction() {
        super("reloadUsersAndGroupsCache");
    }

    @Override
    public void updateAction() {
        UserManager userManager = UserManager.getRecoveryEnabledInstance();
        this.currentUserManagerIndexerStatus = userManager.getSearchEngine().getIndexerStatus((long)Math.max(-1, userManager.getIndexCount()));
        UserGroupManager userGroupManager = UserGroupManager.getRecoveryEnabledInstance();
        this.currentUserGroupsManagerIndexerStatus = userGroupManager.getSearchEngine().getIndexerStatus((long)Math.max(-1, userGroupManager.getIndexCount()));
        this.setDefaultState(this.isIndexerRunning());
    }

    boolean isIndexerRunning() {
        return this.currentUserManagerIndexerStatus.isRunning() || this.currentUserGroupsManagerIndexerStatus.isRunning();
    }

    @Override
    public String executeAction() throws ClientMessageException {
        UserManager.getRecoveryEnabledInstance().getSearchEngine().reIndexAsync();
        UserGroupManager.getRecoveryEnabledInstance().getSearchEngine().reIndexAsync();
        AuthGroupManager.getInstance().getSearchEngine().reIndexAsync();
        return UsersAndGroupsCacheAction.getDefaultExecuteActionMessage();
    }

    int getProgress() {
        double d2 = this.currentUserManagerIndexerStatus.getIndexed();
        d2 = 90.0 * (d2 < 0.0 ? 1.0 : d2 / (double)this.currentUserManagerIndexerStatus.getToBeIndexed());
        double d3 = this.currentUserGroupsManagerIndexerStatus.getIndexed();
        d3 = 10.0 * (d3 < 0.0 ? 1.0 : d3 / (double)this.currentUserGroupsManagerIndexerStatus.getToBeIndexed());
        return (int)(d2 + d3);
    }

    IndexerStatus getUserManagerIndexerStatus() {
        return this.currentUserManagerIndexerStatus;
    }

    IndexerStatus getUserGroupManagerIndexerStatus() {
        return this.currentUserGroupsManagerIndexerStatus;
    }
}

