/*
 * Decompiled with CFR 0.152.
 */
package com.inet.maintenance.server.backup;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.Configuration;
import com.inet.config.RecoveryConfigValue;
import com.inet.http.ClientMessageException;
import com.inet.lib.io.FastBufferedOutputStream;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.IOFunctions;
import com.inet.maintenance.InetMaintenanceServerPlugin;
import com.inet.maintenance.api.MaintenanceHelper;
import com.inet.maintenance.api.backup.BackupContentInformation;
import com.inet.maintenance.api.backup.BackupDefinition;
import com.inet.maintenance.api.backup.BackupHelper;
import com.inet.maintenance.api.backup.BackupJob;
import com.inet.maintenance.api.backup.BackupRunningStatus;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.servlet.ServletUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class a {
    private static final ConfigValue<String> l = new RecoveryConfigValue(ConfigKey.BACKUP_LOCATION);

    public Path c() {
        String string = (String)l.get();
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            Path path = Path.of(string, new String[0]);
            if (!Files.isDirectory(path, new LinkOption[0])) {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (Throwable throwable) {
                    InetMaintenanceServerPlugin.LOGGER.error((Object)("couldn't create directory " + path.toString() + "."));
                    InetMaintenanceServerPlugin.LOGGER.error(throwable);
                    return null;
                }
            }
            return path;
        }
        catch (Exception exception) {
            InetMaintenanceServerPlugin.LOGGER.error((Object)("couldn't resolve path " + string + "."));
            InetMaintenanceServerPlugin.LOGGER.error((Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    public ArrayList<BackupJob> d() {
        Object object = com.inet.maintenance.server.backup.runner.a.t;
        synchronized (object) {
            File file2;
            File[] fileArray;
            Object object22;
            HashSet<String> hashSet = new HashSet<String>();
            @Nonnull List list = ServerPluginManager.getInstance().get(BackupTask.class);
            for (Object object22 : list) {
                hashSet.add(object22.getKey());
            }
            ArrayList arrayList = new ArrayList();
            object22 = this.c();
            if (object22 != null && (fileArray = (file2 = object22.toFile()).listFiles(file -> file.isDirectory())) != null) {
                for (File file3 : fileArray) {
                    File file4 = new File(file3, "backup.information");
                    if (file4.isFile()) {
                        try (FileInputStream fileInputStream = new FileInputStream(file4);){
                            Object object3;
                            BackupJob backupJob = a.a(fileInputStream);
                            Iterator<String> iterator = backupJob.getTaskKeys().iterator();
                            while (iterator.hasNext()) {
                                if (hashSet.contains(iterator.next())) continue;
                                iterator.remove();
                            }
                            Iterator<Map.Entry<String, ArrayList<String>>> iterator2 = backupJob.getContentInformation().getTaskDetails().entrySet().iterator();
                            while (iterator2.hasNext()) {
                                if (hashSet.contains(iterator2.next().getKey())) continue;
                                iterator2.remove();
                            }
                            Iterator<Map.Entry<String, String>> iterator3 = backupJob.getRunningStatus().getTaskErrors().entrySet().iterator();
                            while (iterator3.hasNext()) {
                                object3 = iterator3.next().getKey();
                                if ("null".equals(object3) || hashSet.contains(object3)) continue;
                                iterator3.remove();
                            }
                            object3 = backupJob.getRunningStatus().getTaskProgress().entrySet().iterator();
                            while (object3.hasNext()) {
                                if (hashSet.contains(((Map.Entry)object3.next()).getKey())) continue;
                                object3.remove();
                            }
                            String string = backupJob.getContentInformation().getPath();
                            if (!string.startsWith(file2.getAbsolutePath())) {
                                string = file3.getAbsolutePath();
                                backupJob.getContentInformation().setPath(string);
                                this.b(backupJob);
                            }
                            arrayList.add(backupJob);
                        }
                        catch (Throwable throwable) {
                            InetMaintenanceServerPlugin.LOGGER.warn((Object)throwable);
                        }
                        continue;
                    }
                    InetMaintenanceServerPlugin.LOGGER.warn((Object)("No backup.information in " + file3.toString()));
                }
            }
            return arrayList;
        }
    }

    public long e() {
        long l2 = 0L;
        ArrayList<BackupJob> arrayList = this.d();
        for (BackupJob backupJob : arrayList) {
            l2 += backupJob.getContentInformation().getSize();
        }
        return l2;
    }

    public boolean a(BackupJob backupJob) throws IOException {
        String string = backupJob.getContentInformation().getPath();
        Path path = this.c();
        if (path == null) {
            return false;
        }
        if (string != null && !string.startsWith(path.toString())) {
            return false;
        }
        Path path2 = null;
        try {
            path2 = Path.of(string, new String[0]);
            IOFunctions.deleteDir((Path)path2);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            InetMaintenanceServerPlugin.LOGGER.error((Object)("couldn't remove directory " + string));
            InetMaintenanceServerPlugin.LOGGER.error((Throwable)exception);
            path2 = null;
        }
        return path2 != null && !Files.exists(path2, new LinkOption[0]);
    }

    public void a(BackupJob backupJob, List<@Nonnull String> list, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setContentType("application/zip");
        ServletUtils.setContentDisposition((HttpServletResponse)httpServletResponse, (String)(Path.of(backupJob.getContentInformation().getPath(), new String[0]).toFile().getName() + ".zip"), (boolean)false);
        httpServletResponse.setHeader("Content-Transfer-Encoding", "binary");
        this.a(backupJob, list, (OutputStream)httpServletResponse.getOutputStream());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void a(BackupJob backupJob, List<@Nonnull String> list, OutputStream outputStream) throws IOException {
        String string2;
        Object object;
        BackupContentInformation backupContentInformation = backupJob.getContentInformation().clone();
        BackupRunningStatus backupRunningStatus = backupJob.getRunningStatus().clone();
        HashSet<String> hashSet = new HashSet<String>(backupContentInformation.getTaskDetails().keySet());
        for (String object22 : hashSet) {
            if (list.contains(object22)) continue;
            backupContentInformation.getTaskDetails().remove(object22);
        }
        HashSet<String> hashSet2 = new HashSet<String>(backupRunningStatus.getTaskErrors().keySet());
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if ("null".equals(object)) {
                backupRunningStatus.setFinished(false);
                continue;
            }
            if (list.contains(object)) continue;
            backupRunningStatus.getTaskErrors().remove(object);
        }
        HashSet<String> hashSet3 = new HashSet<String>(backupRunningStatus.getTaskProgress().keySet());
        for (String string2 : hashSet3) {
            if (list.contains(string2)) continue;
            backupRunningStatus.getTaskProgress().remove(string2);
        }
        object = new BackupJob();
        string2 = (ApplicationDescription)ServerPluginManager.getInstance().getSingleInstance(ApplicationDescription.class);
        ((BackupJob)object).setAppNameAndVersion(string2.getApplicationName() + " " + string2.getVersion().getMajor() + "." + string2.getVersion().getMinor());
        ((BackupJob)object).setJobId(UUID.randomUUID());
        ((BackupJob)object).setCreated(backupJob.getCreated());
        ((BackupJob)object).setDefinitionId(backupJob.getDefinitionId());
        ((BackupJob)object).setName(backupJob.getName());
        ((BackupJob)object).setTaskKeys(list);
        ((BackupJob)object).setContentInformation(backupContentInformation);
        ((BackupJob)object).setRunningStatus(backupRunningStatus);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)new FastBufferedOutputStream(outputStream));){
            ZipEntry zipEntry = new ZipEntry("backup.information");
            zipOutputStream.putNextEntry(zipEntry);
            a.a(zipOutputStream, (BackupJob)object);
            zipOutputStream.closeEntry();
            @Nonnull List list2 = ServerPluginManager.getInstance().get(BackupTask.class);
            String string3 = ((BackupJob)object).getContentInformation().getPath();
            Path path = Path.of(string3, new String[0]);
            for (BackupTask backupTask : list2) {
                Path path2;
                if (!list.contains(backupTask.getKey()) || !Files.isDirectory(path2 = path.resolve(backupTask.getKey()), new LinkOption[0])) continue;
                final ArrayList arrayList = new ArrayList();
                Files.walkFileTree(path2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    public FileVisitResult b(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        if (BackupHelper.SYSTEM_FILES.contains(path.getFileName().toString().toLowerCase())) {
                            return FileVisitResult.CONTINUE;
                        }
                        arrayList.add(path2.relativize(path).toString());
                        return super.visitFile(path, basicFileAttributes);
                    }

                    @Override
                    public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                        return this.b((Path)object, basicFileAttributes);
                    }
                });
                for (String string4 : arrayList) {
                    ZipEntry zipEntry2 = new ZipEntry(backupTask.getKey() + "/" + string4);
                    zipOutputStream.putNextEntry(zipEntry2);
                    try (FileInputStream fileInputStream = new FileInputStream(path2.resolve(string4).toFile());){
                        IOFunctions.copyData((InputStream)fileInputStream, (OutputStream)zipOutputStream);
                    }
                    zipOutputStream.closeEntry();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The target is determined by a directory set by the user to extract information from the backup zip file. It is the intended action.")
    public BackupJob a(InputStream inputStream, String string) throws IOException {
        Object object = com.inet.maintenance.server.backup.runner.a.t;
        synchronized (object) {
            Object object2 = null;
            try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
                File file;
                Path path;
                int n = string.lastIndexOf(46);
                if (n > 0) {
                    string = string.substring(0, n);
                }
                if ((path = this.c()) == null) {
                    BackupJob backupJob = null;
                    return backupJob;
                }
                Path path2 = path.resolve(string);
                n = 1;
                while (Files.exists(path2, new LinkOption[0])) {
                    path2 = path.resolve(string + " (" + ++n + ")");
                }
                Files.createDirectories(path2, new FileAttribute[0]);
                ZipEntry zipEntry = null;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    Object object3;
                    if (zipEntry.isDirectory()) continue;
                    file = new File(path2.toFile(), zipEntry.getName());
                    Files.createDirectories(file.toPath().getParent(), new FileAttribute[0]);
                    if ("backup.information".equals(zipEntry.getName())) {
                        object3 = a.a(zipInputStream);
                        ((BackupJob)object3).setCreated(System.currentTimeMillis());
                        ((BackupJob)object3).getContentInformation().setPath(path2.toString());
                        ((BackupJob)object3).setJobId(UUID.randomUUID());
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        a.a(byteArrayOutputStream, (BackupJob)object3);
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                            IOFunctions.copyData((InputStream)byteArrayInputStream, (OutputStream)fileOutputStream);
                        }
                        object2 = object3;
                        continue;
                    }
                    object3 = new FileOutputStream(file);
                    try {
                        IOFunctions.copyData((InputStream)zipInputStream, (OutputStream)object3);
                    }
                    finally {
                        ((FileOutputStream)object3).close();
                    }
                }
                if (object2 == null) {
                    try {
                        IOFunctions.deleteDir((Path)path2);
                    }
                    catch (IOException iOException) {
                        InetMaintenanceServerPlugin.LOGGER.error((Throwable)iOException);
                    }
                }
                file = object2;
                return file;
            }
            catch (ZipException zipException) {
                InetMaintenanceServerPlugin.LOGGER.error((Throwable)zipException);
                return null;
            }
        }
    }

    public void f() {
        ArrayList<BackupJob> arrayList = this.d();
        for (BackupJob backupJob : arrayList) {
            if (backupJob.getContentInformation().getEnded() != 0L) continue;
            backupJob.getContentInformation().setEnded(System.currentTimeMillis());
            backupJob.getRunningStatus().setRunning(false);
            backupJob.getRunningStatus().setWaiting(false);
            backupJob.getRunningStatus().addTaskError(null, InetMaintenanceServerPlugin.MSG.getMsg("backup.error.canceled", new Object[0]));
            this.b(backupJob);
        }
    }

    public void b(BackupJob backupJob) {
        Path path = Path.of(backupJob.getContentInformation().getPath(), new String[0]);
        try (FileOutputStream fileOutputStream = new FileOutputStream(path.resolve("backup.information").toFile());){
            a.a(fileOutputStream, backupJob);
        }
        catch (IOException iOException) {
            InetMaintenanceServerPlugin.LOGGER.error((Throwable)iOException);
        }
    }

    public static BackupJob a(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        return (BackupJob)new Json().fromJson((Reader)inputStreamReader, BackupJob.class, new HashMap());
    }

    public static void a(OutputStream outputStream, BackupJob backupJob) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        new Json().toJson((Object)backupJob, (Appendable)outputStreamWriter);
        outputStreamWriter.flush();
    }

    public static List<@Nonnull BackupDefinition> g() {
        Object object;
        Configuration configuration = MaintenanceHelper.getCurrentConfiguration();
        String string = configuration.get(ConfigKey.BACKUP_DEFINITIONS.getKey(), ConfigKey.BACKUP_DEFINITIONS.getDefault());
        ArrayList<@Nonnull BackupDefinition> arrayList = new ArrayList<BackupDefinition>();
        try {
            object = (Collection)new Json().fromJson(string, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{BackupDefinition.class}));
            Objects.requireNonNull(object);
            arrayList.addAll((Collection<BackupDefinition>)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new boolean[]{false};
        arrayList.stream().filter(backupDefinition -> backupDefinition.getId() == null).forEach(arg_0 -> a.a((boolean[])object, arg_0));
        if (object[0]) {
            a.a(arrayList);
            InetMaintenanceServerPlugin.LOGGER.debug((Object)"Save the modified list of backup definitions. This should really happen only once or if someone tampers with the config.");
        }
        return arrayList;
    }

    public static List<BackupJob> h() {
        ArrayList<BackupJob> arrayList = com.inet.maintenance.server.backup.runner.a.i().getJobs();
        a a2 = new a();
        arrayList.addAll(a2.d());
        return arrayList;
    }

    @Nullable
    public static BackupJob a(UUID uUID) {
        if (uUID == null) {
            return null;
        }
        List<BackupJob> list = a.h();
        list.removeIf(backupJob -> !uUID.equals(backupJob.getJobId()));
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static void a(List<@Nonnull BackupDefinition> list) {
        Configuration configuration = MaintenanceHelper.getCurrentConfiguration();
        String string = new Json().toJson(list);
        configuration.put(ConfigKey.BACKUP_DEFINITIONS.getKey(), string);
    }

    @Nullable
    public static BackupDefinition b(UUID uUID) {
        List<@Nonnull BackupDefinition> list = a.g();
        list.removeIf(backupDefinition -> !backupDefinition.getId().equals(uUID));
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new ClientMessageException(InetMaintenanceServerPlugin.MSG.getMsg("backup.webapi.uuid.notunique", new Object[0]));
        }
        return list.get(0);
    }

    private static /* synthetic */ void a(boolean[] blArray, BackupDefinition backupDefinition) {
        InetMaintenanceServerPlugin.LOGGER.debug((Object)("Persistent definition did not have a required ID: " + backupDefinition.getName() + " (" + String.valueOf(backupDefinition.getId()) + ")."));
        backupDefinition.setId(UUID.randomUUID());
        blArray[0] = true;
    }
}

