/*
 * Decompiled with CFR 0.152.
 */
package com.inet.maintenance.server.taskplanner;

import com.inet.annotations.PublicApi;
import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.maintenance.InetMaintenanceServerPlugin;
import com.inet.maintenance.api.MaintenanceHelper;
import com.inet.maintenance.api.backup.BackupDefinition;
import com.inet.maintenance.server.backup.a;
import com.inet.maintenance.server.taskplanner.b;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.LabelField;
import com.inet.taskplanner.server.api.field.LinkField;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.job.ConditionDefinition;
import com.inet.taskplanner.server.api.job.ConditionInfo;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.taskplanner.server.api.job.JobInfo;
import com.inet.taskplanner.server.api.job.JobSummaryInfo;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public class BackupJobFactory
extends JobFactory<b> {
    public static final String PROPERTY_BACKUP_JOB_ID = "job.backup.selection";

    public BackupJobFactory() {
        super("job.backup");
    }

    /*
     * WARNING - void declaration
     */
    public JobInfo getInformation(@Nullable GUID taskID) {
        String string;
        void var9_16;
        Object object2;
        BackupDefinition[] selectField;
        String string2 = InetMaintenanceServerPlugin.MSG.getMsg("job.backup.name", new Object[0]);
        String string3 = InetMaintenanceServerPlugin.MSG.getMsg("job.backup.description", new Object[0]);
        URL uRL = ((Object)((Object)this)).getClass().getResource("/com/inet/maintenance/server/taskplanner/backupjob.png");
        String string4 = "taskplanner.job.backup";
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<LocalizedKey> arrayList2 = new ArrayList<LocalizedKey>();
        for (Object object2 : selectField = BackupJobFactory.getBackupDefinitions()) {
            arrayList2.add(new LocalizedKey(((BackupDefinition)object2).getId().toString(), ((BackupDefinition)object2).getName()));
        }
        if (arrayList2.size() > 0) {
            SelectField selectField2 = new SelectField(PROPERTY_BACKUP_JOB_ID, InetMaintenanceServerPlugin.MSG.getMsg(PROPERTY_BACKUP_JOB_ID, new Object[0]), arrayList2);
            selectField2.setValue(((LocalizedKey)arrayList2.get(0)).getKey());
            arrayList.add(selectField2);
        } else {
            LabelField labelField = new LabelField("job.backup.selection.nonedefined", InetMaintenanceServerPlugin.MSG.getMsg(PROPERTY_BACKUP_JOB_ID, new Object[0]), InetMaintenanceServerPlugin.MSG.getMsg("job.backup.selection.nonedefined", new Object[0]));
            arrayList.add(labelField);
        }
        String string5 = "maintenance/backup";
        String string6 = SessionStore.getRootURL();
        if (string6 != null) {
            String string7 = string6 + string5;
        } else {
            String string8 = "../" + string5;
        }
        LinkField linkField = new LinkField("job.backup.hint.link", InetMaintenanceServerPlugin.MSG.getMsg("job.backup.hint", new Object[0]), (String)var9_16, InetMaintenanceServerPlugin.MSG.getMsg("job.backup.hint.link", new Object[0]));
        arrayList.add(linkField);
        object2 = new a().c();
        String string9 = string = object2 == null ? "" : object2.toString();
        if (StringFunctions.isEmpty((String)string)) {
            if (arrayList2.size() > 0) {
                arrayList.add(new LabelField("job.backup.hint.storage", "", InetMaintenanceServerPlugin.MSG.getMsg("job.backup.hint.storage.notset", new Object[0])));
            }
        } else {
            arrayList.add(new LabelField("job.backup.hint.storage", "", InetMaintenanceServerPlugin.MSG.getMsg("job.backup.hint.storage", new Object[]{string})));
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.add("backup.name");
        ArrayList<SelectField> arrayList4 = new ArrayList<SelectField>();
        ArrayList<LocalizedKey> arrayList5 = new ArrayList<LocalizedKey>();
        arrayList5.add(new LocalizedKey("job.backup.condition.errorhandling.successful", InetMaintenanceServerPlugin.MSG.getMsg("job.backup.condition.errorhandling.successful", new Object[0])));
        arrayList5.add(new LocalizedKey("job.backup.condition.errorhandling.erroneous", InetMaintenanceServerPlugin.MSG.getMsg("job.backup.condition.errorhandling.erroneous", new Object[0])));
        SelectField selectField3 = new SelectField("job.backup.condition.errorhandling", InetMaintenanceServerPlugin.MSG.getMsg("job.backup.condition.errorhandling", new Object[0]), arrayList5);
        selectField3.setValue("job.backup.condition.errorhandling.successful");
        arrayList4.add(selectField3);
        JobInfo jobInfo = new JobInfo(this.getExtensionName(), string2, string3, uRL, string4, new ConditionInfo(arrayList4), arrayList, arrayList3);
        return jobInfo;
    }

    protected static BackupDefinition[] getBackupDefinitions() {
        Configuration configuration = MaintenanceHelper.getCurrentConfiguration();
        String string = configuration.get(ConfigKey.BACKUP_DEFINITIONS.getKey(), ConfigKey.BACKUP_DEFINITIONS.getDefault());
        BackupDefinition[] backupDefinitionArray = null;
        if (string != null && string.startsWith("[")) {
            backupDefinitionArray = (BackupDefinition[])new Json().fromJson(string, BackupDefinition[].class);
        }
        if (backupDefinitionArray == null) {
            backupDefinitionArray = new BackupDefinition[]{};
        }
        return backupDefinitionArray;
    }

    public void validate(@Nonnull JobDefinition jobDefinition, @Nullable GUID taskID) throws ValidationException {
        BackupDefinition[] backupDefinitionArray;
        UUID uUID = this.a(jobDefinition);
        if (uUID == null) {
            throw new ValidationException(new String[]{InetMaintenanceServerPlugin.MSG.getMsg("job.backup.selection.noneselected", new Object[0])});
        }
        for (BackupDefinition backupDefinition : backupDefinitionArray = BackupJobFactory.getBackupDefinitions()) {
            if (!backupDefinition.getId().equals(uUID)) continue;
            return;
        }
        throw new ValidationException(new String[]{InetMaintenanceServerPlugin.MSG.getMsg("job.backup.selection.doesnotexist", new Object[0])});
    }

    public void validateCondition(@Nonnull JobDefinition definition) throws ValidationException {
    }

    protected b createInstanceFrom(@Nonnull JobDefinition definition, @Nullable GUID taskID) {
        return new b(definition.getCondition(), this.a(definition));
    }

    public JobSummaryInfo getSummary(@Nonnull JobDefinition definition) {
        ArrayList<SummaryEntry> arrayList = new ArrayList<SummaryEntry>();
        UUID uUID = this.a(definition);
        BackupDefinition[] backupDefinitionArray = BackupJobFactory.getBackupDefinitions();
        boolean bl = false;
        for (BackupDefinition object2 : backupDefinitionArray) {
            if (!object2.getId().equals(uUID)) continue;
            bl = true;
            arrayList.add(new SummaryEntry(InetMaintenanceServerPlugin.MSG.getMsg(PROPERTY_BACKUP_JOB_ID, new Object[0]), object2.getName()));
            break;
        }
        if (!bl) {
            arrayList.add(new SummaryEntry(InetMaintenanceServerPlugin.MSG.getMsg(PROPERTY_BACKUP_JOB_ID, new Object[0]), InetMaintenanceServerPlugin.MSG.getMsg("job.backup.selection.doesnotexist", new Object[0])));
        }
        Object object = null;
        ConditionDefinition conditionDefinition = definition.getCondition();
        if (conditionDefinition != null) {
            String string = null;
            String string2 = (String)conditionDefinition.getProperties().get("job.backup.condition.errorhandling");
            string = InetMaintenanceServerPlugin.MSG.getMsg(string2, new Object[0]);
            object = new ArrayList();
            object.add(new SummaryEntry(InetMaintenanceServerPlugin.MSG.getMsg("job.backup.condition", new Object[0]), string));
        }
        return new JobSummaryInfo(arrayList, (List)object);
    }

    public List<ResultFlavor> getResultFlavors(JobDefinition definition) {
        return Arrays.asList(ResultFlavor.FILE, ResultFlavor.TEXT);
    }

    public boolean isAvailable() {
        return SystemPermissionChecker.checkAccess((Permission)Permission.valueOfExistingOrCreate((String)"configuration"));
    }

    @Nullable
    private UUID a(JobDefinition jobDefinition) {
        try {
            String string = jobDefinition.getProperty(PROPERTY_BACKUP_JOB_ID);
            return UUID.fromString(string);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            return null;
        }
    }
}

