/*
 * Decompiled with CFR 0.152.
 */
package com.inet.maintenance.api.backup;

import com.inet.annotations.InternalApi;
import com.inet.id.GUID;
import com.inet.lib.io.FastBufferedOutputStream;
import com.inet.lib.util.IOFunctions;
import com.inet.maintenance.api.backup.FileProgress;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class BackupHelper {
    public static final Set<String> SYSTEM_FILES = new HashSet<String>(){
        {
            this.add("desktop.ini");
            this.add("thumbs.db");
            this.add(".ds-store");
            this.add("_.ds-store");
        }
    };

    public void createZipFromFolderContent(PersistenceEntry source, Path target, FileProgress progress) throws FileNotFoundException, IOException {
        long l2 = source.searchCount("*");
        Iterable iterable = source.search("*");
        progress.progressUpdate(10, 0);
        int n = 0;
        int n2 = 0;
        try (FileOutputStream fileOutputStream = new FileOutputStream(target.toFile());
             ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)fileOutputStream));){
            int n3 = source.getPath().length() + 1;
            for (PersistenceEntry persistenceEntry : iterable) {
                if (SYSTEM_FILES.contains(persistenceEntry.getName().toLowerCase())) continue;
                ++n2;
                InputStream inputStream = persistenceEntry.getInputStream();
                if (inputStream == null) continue;
                String string = persistenceEntry.getPath().substring(n3);
                ZipEntry zipEntry = new ZipEntry(string);
                zipOutputStream.putNextEntry(zipEntry);
                IOFunctions.copyData((InputStream)inputStream, (OutputStream)zipOutputStream);
                zipOutputStream.closeEntry();
                inputStream.close();
                progress.progressUpdate(10 + (int)Math.ceil((double)n2 / (double)l2 * 90.0), ++n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="A temporary file is being created using the persistence entry file name which is not determined by a user.")
    public void extractZipIntoFolder(Path source, PersistenceEntry target, boolean deleteOld, FileProgress fileProgress) throws ZipException, IOException {
        if (!Files.isRegularFile(source, new LinkOption[0])) {
            return;
        }
        PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve("temp-" + target.getName() + "-" + GUID.generateNew().toString());
        try {
            int n = 0;
            try (ZipFile zipFile = new ZipFile(source.toFile());){
                int n2 = 0;
                n = zipFile.size();
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    if (!zipEntry.isDirectory()) {
                        PersistenceEntry persistenceEntry2 = persistenceEntry.resolve(zipEntry.getName());
                        InputStream inputStream = zipFile.getInputStream(zipEntry);
                        persistenceEntry2.setInputStream(inputStream);
                    }
                    fileProgress.progressUpdate((int)Math.ceil((double)(++n2) / (double)n * 50.0), 0);
                }
            }
            if (deleteOld) {
                target.deleteTree();
            }
            BackupHelper.a(persistenceEntry, target, fileProgress, 0, n);
        }
        finally {
            persistenceEntry.deleteTree();
        }
    }

    private static int a(PersistenceEntry persistenceEntry, PersistenceEntry persistenceEntry2, FileProgress fileProgress, int n, int n2) throws IOException {
        List list = persistenceEntry.getChildren();
        for (PersistenceEntry persistenceEntry3 : list) {
            PersistenceEntry persistenceEntry4 = persistenceEntry2.resolve(persistenceEntry3.getName());
            ++n;
            try (Object object = persistenceEntry3.getInputStream();){
                if (object != null) {
                    persistenceEntry4.setInputStream((InputStream)object);
                }
            }
            object = persistenceEntry3.getChildren();
            if (!object.isEmpty()) {
                n = BackupHelper.a(persistenceEntry3, persistenceEntry4, fileProgress, n, n2);
            }
            fileProgress.progressUpdate((int)Math.ceil(50.0 + (double)n / (double)n2 * 50.0), 0);
        }
        return n;
    }

    public void createZipFromPathMap(HashMap<String, String> sources, Path target, final FileProgress progress) throws FileNotFoundException, IOException {
        Object object;
        final AtomicLong atomicLong = new AtomicLong(0L);
        for (String object22 : sources.keySet()) {
            object = Path.of(sources.get(object22), new String[0]);
            if (!object.toFile().exists() || !Files.exists((Path)object, new LinkOption[0])) continue;
            Files.walkFileTree((Path)object, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                public FileVisitResult a(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (!Files.exists(path, new LinkOption[0])) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return super.preVisitDirectory(path, basicFileAttributes);
                }

                public FileVisitResult a(Path path, IOException iOException) throws IOException {
                    if (!Files.exists(path, new LinkOption[0])) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (iOException instanceof NoSuchFileException) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return super.postVisitDirectory(path, iOException);
                }

                public FileVisitResult b(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (!Files.exists(path, new LinkOption[0])) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (SYSTEM_FILES.contains(path.getFileName().toString().toLowerCase())) {
                        return FileVisitResult.CONTINUE;
                    }
                    atomicLong.addAndGet(Files.size(path));
                    return super.visitFile(path, basicFileAttributes);
                }

                @Override
                public /* synthetic */ FileVisitResult postVisitDirectory(Object object, IOException iOException) throws IOException {
                    return this.a((Path)object, iOException);
                }

                @Override
                public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                    return this.b((Path)object, basicFileAttributes);
                }

                @Override
                public /* synthetic */ FileVisitResult preVisitDirectory(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                    return this.a((Path)object, basicFileAttributes);
                }
            });
        }
        progress.progressUpdate(10, 0);
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        final AtomicLong atomicLong2 = new AtomicLong(0L);
        object = new FileOutputStream(target.toFile());
        try (final ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)object);){
            for (final String string : sources.keySet()) {
                Path path = Path.of(sources.get(string), new String[0]);
                if (!path.toFile().exists() || !Files.exists(path, new LinkOption[0])) continue;
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    public FileVisitResult a(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        if (!Files.exists(path, new LinkOption[0])) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        return super.preVisitDirectory(path, basicFileAttributes);
                    }

                    public FileVisitResult a(Path path, IOException iOException) throws IOException {
                        if (!Files.exists(path, new LinkOption[0])) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        if (iOException instanceof NoSuchFileException) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        return super.postVisitDirectory(path, iOException);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public FileVisitResult b(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        if (!Files.exists(path, new LinkOption[0])) {
                            return FileVisitResult.CONTINUE;
                        }
                        if (SYSTEM_FILES.contains(path.getFileName().toString().toLowerCase())) {
                            return FileVisitResult.CONTINUE;
                        }
                        ZipEntry zipEntry = new ZipEntry(string);
                        zipOutputStream.putNextEntry(zipEntry);
                        try (FileInputStream fileInputStream = new FileInputStream(path.toFile());){
                            IOFunctions.copyData((InputStream)fileInputStream, (OutputStream)zipOutputStream);
                        }
                        finally {
                            zipOutputStream.closeEntry();
                        }
                        atomicLong2.addAndGet(Files.size(path));
                        progress.progressUpdate((int)Math.ceil(atomicLong2.doubleValue() / atomicLong.doubleValue() * 90.0), atomicInteger.incrementAndGet());
                        return super.visitFile(path, basicFileAttributes);
                    }

                    @Override
                    public /* synthetic */ FileVisitResult postVisitDirectory(Object object, IOException iOException) throws IOException {
                        return this.a((Path)object, iOException);
                    }

                    @Override
                    public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                        return this.b((Path)object, basicFileAttributes);
                    }

                    @Override
                    public /* synthetic */ FileVisitResult preVisitDirectory(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                        return this.a((Path)object, basicFileAttributes);
                    }
                });
            }
        }
        finally {
            ((FileOutputStream)object).close();
        }
    }

    public void extractZipIntoFiles(Path source, HashMap<String, String> targets, FileProgress fileProgress) throws ZipException, IOException {
        if (!Files.isRegularFile(source, new LinkOption[0])) {
            return;
        }
        try (ZipFile zipFile = new ZipFile(source.toFile());){
            AtomicLong atomicLong = new AtomicLong(zipFile.size());
            AtomicLong atomicLong2 = new AtomicLong(0L);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.isDirectory() && targets.containsKey(zipEntry.getName())) {
                    Path path = Path.of(targets.get(zipEntry.getName()), new String[0]);
                    if (path.getParent() != null) {
                        Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    }
                    try (FileOutputStream fileOutputStream = new FileOutputStream(path.toFile());){
                        InputStream inputStream = zipFile.getInputStream(zipEntry);
                        IOFunctions.copyData((InputStream)inputStream, (OutputStream)fileOutputStream);
                    }
                }
                atomicLong2.incrementAndGet();
                fileProgress.progressUpdate((int)Math.ceil(atomicLong2.doubleValue() / atomicLong.doubleValue() * 90.0), atomicLong.intValue());
            }
        }
    }

    public String normalizeName(String name, boolean stripSpecialChars) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char c2 = name.charAt(i2);
            if (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 == ' ' || c2 == '-' || c2 == '_' || c2 == '.') {
                stringBuilder.append(c2);
                continue;
            }
            if (stripSpecialChars) continue;
            stringBuilder.append('#');
            int n = Character.getNumericValue(c2);
            stringBuilder.append(n >= 0 ? n : (int)c2);
        }
        return stringBuilder.toString();
    }
}

