/*
 * Decompiled with CFR 0.152.
 */
package com.inet.maintenance.api.backup;

import com.inet.annotations.JsonData;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.UUID;

@JsonData
@Schema(description="Represents a backup definition that can be executed knowing the id")
public class BackupDefinition {
    @Schema(description="The name of the backup definition", example="Weekly System Backup")
    private String name;
    @Schema(description="The unique identifier of the backup definition", example="550e8400-e29b-41d4-a716-446655440000")
    private String id;
    @Schema(description="List of backup tasks/items to be included in this backup", example="[\"system\", \"database\", \"files\"]")
    private ArrayList<String> items;
    @Schema(description="Number of backup versions to keep", example="10")
    private int numberOfVersions = 10;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UUID getId() {
        try {
            return UUID.fromString(this.id);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            return null;
        }
    }

    public void setId(UUID id) {
        this.id = id == null ? null : id.toString();
    }

    public ArrayList<String> getItems() {
        return this.items;
    }

    public void setItems(ArrayList<String> items) {
        this.items = items;
    }

    public int getNumberOfVersions() {
        return this.numberOfVersions;
    }

    public void setNumberOfVersions(int numberOfVersions) {
        this.numberOfVersions = numberOfVersions;
    }
}

