/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.plugins.maintenance.server.cache;

import com.inet.annotations.JsonData;
import com.inet.http.ClientMessageException;
import com.inet.maintenance.api.cache.MaintenanceCacheAction;
import com.inet.report.ReportException;
import com.inet.report.cache.Cache;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.plugins.maintenance.CRMaintenanceServerPlugin;
import com.inet.report.plugins.maintenance.server.cache.a;

@JsonData
public class ReportCacheAction
extends MaintenanceCacheAction {
    public ReportCacheAction() {
        super("clearReportCache");
    }

    public void updateAction() {
        int n = 0;
        try {
            n = Cache.getCache().getReports().size();
        }
        catch (ReportException reportException) {
            CRMaintenanceServerPlugin.LOGGER.error((Throwable)reportException);
        }
        this.setEnabled(n > 0);
        this.setTitle(a.MSG.getMsg(n > 0 ? "reportCache.button" : "reportCache.button.disabled", new Object[0]));
    }

    public String executeAction() throws ClientMessageException {
        try {
            Cache cache = Cache.getCache();
            for (ReportCacheKey reportCacheKey : cache.getReports()) {
                cache.delete(reportCacheKey);
            }
        }
        catch (ReportException reportException) {
            CRMaintenanceServerPlugin.LOGGER.error((Throwable)reportException);
        }
        return a.MSG.getMsg("reportCache.cachecleared", new Object[0]);
    }
}

