/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugins.maintenance.server.comparisons;

import com.inet.annotations.JsonData;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.plugin.persistence.PersistenceFactory;
import com.inet.pdfc.plugin.persistence.UserPersistenceManager;
import com.inet.pdfc.plugins.maintenance.PDFCMaintenanceServerPlugin;
import com.inet.pdfc.plugins.maintenance.server.comparisons.Comparison;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class ComparisonsUtils {
    private static void a(BiConsumer<GUID, ComparePersistence.ComparePersistenceMetaData> biConsumer) throws IOException {
        UserPersistenceManager userPersistenceManager = (UserPersistenceManager)ServerPluginManager.getInstance().getSingleInstance(UserPersistenceManager.class);
        List list = userPersistenceManager.getManagedUserIDs();
        if (list.size() > 0) {
            for (GUID gUID : list) {
                Map map = userPersistenceManager.getComparisonsForUser(gUID);
                for (Map.Entry entry : map.entrySet()) {
                    biConsumer.accept((GUID)entry.getKey(), (ComparePersistence.ComparePersistenceMetaData)entry.getValue());
                }
            }
        }
    }

    public static Ranges a() throws IOException {
        final Ranges ranges = new Ranges();
        ComparisonsUtils.a(new BiConsumer<GUID, ComparePersistence.ComparePersistenceMetaData>(){

            public void a(GUID gUID, ComparePersistence.ComparePersistenceMetaData comparePersistenceMetaData) {
                long l = comparePersistenceMetaData.getSize();
                long l2 = comparePersistenceMetaData.getLastModified();
                ranges.minDate = Math.min(ranges.getMinDate(), l2);
                ranges.maxDate = Math.max(ranges.getMaxDate(), l2);
                ranges.minSize = Math.min(ranges.getMinSize(), l);
                ranges.maxSize = Math.max(ranges.getMaxSize(), l);
            }

            @Override
            public /* synthetic */ void accept(Object object, Object object2) {
                this.a((GUID)object, (ComparePersistence.ComparePersistenceMetaData)object2);
            }
        });
        ranges.minSize = ComparisonsUtils.a(ranges.getMinSize(), false);
        ranges.maxSize = ComparisonsUtils.a(ranges.getMaxSize(), true);
        ranges.matrix = new RangeEntry[100][100];
        ranges.dates = new Range[100];
        ranges.sizes = new Range[100];
        double d2 = (double)(ranges.getMaxSize() - ranges.getMinSize()) / 100.0;
        double d3 = (double)(ranges.getMaxDate() - ranges.getMinDate()) / 100.0;
        long l = ranges.getMinSize() - 1L;
        long l2 = ranges.getMinDate() - 1L;
        for (int i = 0; i < 100; ++i) {
            long l3 = l + 1L;
            l = Math.round((double)ranges.getMinSize() + d2 * (double)(i + 1));
            ranges.getSizes()[i] = new Range(l3, l);
            long l4 = l2 + 1L;
            l2 = Math.round((double)ranges.getMinDate() + d3 * (double)(i + 1));
            ranges.getDates()[i] = new Range(l4, l2);
        }
        ComparisonsUtils.a(new BiConsumer<GUID, ComparePersistence.ComparePersistenceMetaData>(){

            public void a(GUID gUID, ComparePersistence.ComparePersistenceMetaData comparePersistenceMetaData) {
                Object object;
                int n;
                Range range;
                int n2;
                long l = comparePersistenceMetaData.getSize();
                long l2 = comparePersistenceMetaData.getLastModified();
                boolean bl = comparePersistenceMetaData.isPublic();
                for (n2 = 0; n2 < 100 && (l < (range = ranges.getSizes()[n2]).getStart() || l > range.getEnd()); ++n2) {
                }
                for (n = 0; n < 100 && (l2 < ((Range)(object = ranges.getDates()[n])).getStart() || l2 > ((Range)object).getEnd()); ++n) {
                }
                if (n2 >= 100 || n >= 100) {
                    return;
                }
                object = ranges.matrix[n][n2];
                if (object == null) {
                    ranges.matrix[n][n2] = object = new RangeEntry(0L, 0L, 0L, 0L);
                }
                if (bl) {
                    ++((RangeEntry)object).puct;
                    ((RangeEntry)object).pusz += l;
                } else {
                    ++((RangeEntry)object).prct;
                    ((RangeEntry)object).prsz += l;
                }
                ++ranges.count;
                ranges.size += l;
            }

            @Override
            public /* synthetic */ void accept(Object object, Object object2) {
                this.a((GUID)object, (ComparePersistence.ComparePersistenceMetaData)object2);
            }
        });
        return ranges;
    }

    private static long a(long l, boolean bl) {
        double d2 = 1048576.0;
        double d3 = d2 * 1024.0;
        double d4 = d3 * 1024.0;
        if ((double)l > d4) {
            return ComparisonsUtils.a((double)l / d4, bl) * (long)d4;
        }
        if ((double)l > d3) {
            return ComparisonsUtils.a((double)l / d3, bl) * (long)d3;
        }
        return ComparisonsUtils.a((double)l / d2, bl) * (long)d2;
    }

    private static long a(double d2, boolean bl) {
        return (long)(bl ? Math.ceil(d2) : Math.floor(d2));
    }

    public static HashMap<GUID, ComparePersistence.ComparePersistenceMetaData> b() throws IOException {
        final PersistenceFactory persistenceFactory = (PersistenceFactory)ServerPluginManager.getInstance().getSingleInstance(PersistenceFactory.class);
        final HashMap<GUID, ComparePersistence.ComparePersistenceMetaData> hashMap = new HashMap<GUID, ComparePersistence.ComparePersistenceMetaData>();
        try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
            ComparisonsUtils.a(new BiConsumer<GUID, ComparePersistence.ComparePersistenceMetaData>(){

                public void a(GUID gUID, ComparePersistence.ComparePersistenceMetaData comparePersistenceMetaData) {
                    try {
                        ComparePersistence comparePersistence = persistenceFactory.getPersistenceSystemAccess(gUID);
                        if (comparePersistence == null) {
                            return;
                        }
                        GUID gUID2 = comparePersistence.getOwnerID();
                        if (!hashMap.containsKey(gUID2)) {
                            hashMap.put(gUID2, comparePersistenceMetaData);
                        } else {
                            ComparePersistence.ComparePersistenceMetaData comparePersistenceMetaData2 = (ComparePersistence.ComparePersistenceMetaData)hashMap.get(gUID2);
                            hashMap.replace(gUID2, ComparisonsUtils.a(comparePersistenceMetaData2, comparePersistenceMetaData));
                        }
                    }
                    catch (Throwable throwable) {
                        PDFCMaintenanceServerPlugin.LOGGER.error(throwable);
                    }
                }

                @Override
                public /* synthetic */ void accept(Object object, Object object2) {
                    this.a((GUID)object, (ComparePersistence.ComparePersistenceMetaData)object2);
                }
            });
        }
        return hashMap;
    }

    public static ComparePersistence.ComparePersistenceMetaData a(ComparePersistence.ComparePersistenceMetaData comparePersistenceMetaData, ComparePersistence.ComparePersistenceMetaData comparePersistenceMetaData2) {
        ComparePersistence.ComparePersistenceMetaData comparePersistenceMetaData3 = new ComparePersistence.ComparePersistenceMetaData(Math.max(comparePersistenceMetaData.getLastModified(), comparePersistenceMetaData2.getLastModified()), comparePersistenceMetaData.getSize() + comparePersistenceMetaData2.getSize(), comparePersistenceMetaData.isPublic() || comparePersistenceMetaData2.isPublic(), comparePersistenceMetaData.getDifferences() + comparePersistenceMetaData2.getDifferences());
        return comparePersistenceMetaData3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long a(final Range range, final Range range2, final boolean bl) throws IOException {
        PersistenceFactory persistenceFactory = (PersistenceFactory)ServerPluginManager.getInstance().getSingleInstance(PersistenceFactory.class);
        final HashSet hashSet = new HashSet();
        long l = 0L;
        try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
            ComparisonsUtils.a(new BiConsumer<GUID, ComparePersistence.ComparePersistenceMetaData>(){

                public void a(GUID gUID, ComparePersistence.ComparePersistenceMetaData comparePersistenceMetaData) {
                    long l = comparePersistenceMetaData.getSize();
                    long l2 = comparePersistenceMetaData.getLastModified();
                    if (l2 >= range2.getStart() && l2 <= range2.getEnd() && l >= range.getStart() && l <= range.getEnd()) {
                        if (!bl && comparePersistenceMetaData.isPublic()) {
                            return;
                        }
                        hashSet.add(gUID);
                    }
                }

                @Override
                public /* synthetic */ void accept(Object object, Object object2) {
                    this.a((GUID)object, (ComparePersistence.ComparePersistenceMetaData)object2);
                }
            });
            if (hashSet.size() <= 0) return l;
            for (GUID gUID : hashSet) {
                try {
                    persistenceFactory.remove(gUID, true);
                    ++l;
                }
                catch (Throwable throwable) {
                    throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable));
                    return l;
                }
            }
        }
    }

    public static ArrayList<Comparison> a(Range range, Range range2, boolean bl, String string, int n, int n2, UserManager userManager) throws AccessDeniedException, IOException {
        PersistenceFactory persistenceFactory = (PersistenceFactory)ServerPluginManager.getInstance().getSingleInstance(PersistenceFactory.class);
        IndexSearchEngine indexSearchEngine = persistenceFactory.getSearchIndex();
        TextSearchCommandBuilder textSearchCommandBuilder = new TextSearchCommandBuilder(indexSearchEngine, string);
        SearchCommand searchCommand = textSearchCommandBuilder.build();
        AndSearchExpression andSearchExpression = searchCommand.getSearchExpression();
        andSearchExpression.add((SearchExpression)new SearchCondition(PersistenceFactory.TAG.GUID.getTag().getTag(), SearchCondition.SearchTermOperator.StartsWith, (Object)""));
        andSearchExpression.add((SearchExpression)new SearchCondition(PersistenceFactory.TAG.MODIFIED.getTag().getTag(), SearchCondition.SearchTermOperator.BETWEEN, (Object)new Object[]{Long.toString(range2.getStart()), Long.toString(range2.getEnd() + 2500L)}));
        andSearchExpression.add((SearchExpression)new SearchCondition(PersistenceFactory.TAG.SIZE.getTag().getTag(), SearchCondition.SearchTermOperator.BETWEEN, (Object)new Object[]{Long.toString(range.getStart() - 1L), Long.toString(range.getEnd() + 1L)}));
        if (!bl) {
            andSearchExpression.add((SearchExpression)new SearchCondition(PersistenceFactory.TAG.PUBLIC.getTag().getTag(), SearchCondition.SearchTermOperator.Equals, (Object)ComparePersistence.PUBLICATION_MODE.none.ordinal()));
        }
        SearchResult searchResult = indexSearchEngine.search(searchCommand);
        List list = searchResult.getEntries();
        ArrayList<Comparison> arrayList = new ArrayList<Comparison>();
        for (SearchResultEntry searchResultEntry : list) {
            ComparePersistence comparePersistence = persistenceFactory.getPersistenceSystemAccess((GUID)searchResultEntry.getId());
            if (comparePersistence == null) continue;
            GUID gUID = comparePersistence.getOwnerID();
            String string2 = userManager.getUserAccount(gUID).getDisplayName();
            Object object = comparePersistence.getTagValue(PersistenceFactory.TAG.MODIFIED);
            arrayList.add(new Comparison(((GUID)searchResultEntry.getId()).toString(), (String)comparePersistence.getTagValue(PersistenceFactory.TAG.NAME), string2, (String)comparePersistence.getTagValue(PersistenceFactory.TAG.DOCUMENT_1), (String)comparePersistence.getTagValue(PersistenceFactory.TAG.DOCUMENT_2), comparePersistence.getTotalSize(), object != null ? (Long)object : 0L, comparePersistence.getPublicationMode() != ComparePersistence.PUBLICATION_MODE.none));
        }
        Collections.sort(arrayList, (comparison, comparison2) -> {
            if (comparison.getLastModified() != comparison2.getLastModified()) {
                return (int)Math.signum(comparison.getLastModified() - comparison2.getLastModified());
            }
            if (comparison.getSize() != comparison2.getSize()) {
                return (int)Math.signum(comparison.getSize() - comparison2.getSize());
            }
            int n = comparison.getOwner().compareTo(comparison2.getOwner());
            if (n != 0) {
                return n;
            }
            return comparison.getGuid().compareTo(comparison2.getGuid());
        });
        return arrayList;
    }

    @JsonData
    public static final class Ranges {
        private long minDate = Long.MAX_VALUE;
        private long maxDate = 0L;
        private long minSize = Long.MAX_VALUE;
        private long maxSize = 0L;
        private long count = 0L;
        private long size = 0L;
        private Range[] dates = null;
        private Range[] sizes = null;
        private RangeEntry[][] matrix = null;

        public long getMinDate() {
            return this.minDate;
        }

        public long getMaxDate() {
            return this.maxDate;
        }

        public long getMinSize() {
            return this.minSize;
        }

        public long getMaxSize() {
            return this.maxSize;
        }

        public Range[] getDates() {
            return this.dates;
        }

        public Range[] getSizes() {
            return this.sizes;
        }
    }

    @JsonData
    public static final class RangeEntry {
        private long prct = 0L;
        private long prsz = 0L;
        private long puct = 0L;
        private long pusz = 0L;

        public RangeEntry(long prct, long prsz, long puct, long pusz) {
            this.prct = prct;
            this.prsz = prsz;
            this.puct = puct;
            this.pusz = pusz;
        }

        public String toString() {
            return "PrivatCount:" + this.prct + ", PrivateSize:" + this.prsz + ", PublicCount:" + this.puct + ", PublicSize:" + this.pusz;
        }
    }

    @JsonData
    public static final class Range {
        private long start = 0L;
        private long end = 0L;

        private Range() {
        }

        public Range(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "Start:" + this.start + ", End:" + this.end;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }
    }
}

