/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugins.maintenance.server.comparisons;

import com.inet.annotations.JsonData;
import java.util.Calendar;

@JsonData
public class Comparison {
    private static final Calendar CALENDAR = Calendar.getInstance();
    private String guid;
    private String title;
    private String owner;
    private String firstDocumentName;
    private String secondDocumentName;
    private long size;
    private long sizeRounded;
    private long lastmodified;
    private long lastmodifiedRounded;
    private boolean published;

    public Comparison(String guid, String title, String owner, String firstDocumentName, String secondDocumentName, long size, long lastmodified, boolean published) {
        this.guid = guid;
        this.title = title;
        this.owner = owner;
        this.firstDocumentName = firstDocumentName;
        this.secondDocumentName = secondDocumentName;
        this.size = size;
        this.sizeRounded = Comparison.getAsMB(size);
        this.lastmodified = lastmodified;
        this.lastmodifiedRounded = Comparison.getDayStart(lastmodified);
        this.published = published;
    }

    private static long getAsMB(long size) {
        return (int)Math.ceil((double)size / 1024.0 / 1024.0);
    }

    private static long getDayStart(long timestamp) {
        CALENDAR.setTimeInMillis(timestamp);
        CALENDAR.set(11, 0);
        CALENDAR.set(12, 0);
        CALENDAR.set(13, 0);
        CALENDAR.set(14, 0);
        return CALENDAR.getTimeInMillis();
    }

    public long getLastModified() {
        return this.lastmodified;
    }

    public long getSize() {
        return this.size;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getGuid() {
        return this.guid;
    }
}

