/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugins.maintenance.server.backup;

import com.inet.maintenance.api.backup.BackupContentInformation;
import com.inet.maintenance.api.backup.BackupHelper;
import com.inet.maintenance.api.backup.BackupRunningStatus;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.maintenance.api.backup.FileProgress;
import com.inet.maintenance.api.backup.ProgressUpdater;
import com.inet.pdfc.plugins.maintenance.PDFCMaintenanceServerPlugin;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ApplicationDescription;
import com.inet.shared.utils.Version;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class a
implements BackupTask {
    public String getKey() {
        return "comparisons";
    }

    public String getTitle() {
        return PDFCMaintenanceServerPlugin.MSG.getMsg("backup.comparisons.title", new Object[0]);
    }

    public String getDescription() {
        return PDFCMaintenanceServerPlugin.MSG.getMsg("backup.comparisons.description", new Object[0]);
    }

    public URL getIconURL() {
        return this.getClass().getResource("/com/inet/pdfc/plugins/maintenance/server/backup/PDFC_icon_32.png");
    }

    public void execute(Path taskPath, BackupRunningStatus runningStatus, final BackupContentInformation contentInformation, final ProgressUpdater progressUpdater) throws Throwable {
        BackupHelper backupHelper = new BackupHelper();
        backupHelper.createZipFromFolderContent(Persistence.getRecoveryEnabledInstance().resolve("persistence"), taskPath.resolve("comparisons.zip"), new FileProgress(){

            public void progressUpdate(int progress, int files) {
                final String string = PDFCMaintenanceServerPlugin.MSG.getMsg("backup.comparisons.taskdetail", new Object[]{files});
                contentInformation.putTaskDetails(a.this.getKey(), (ArrayList)new ArrayList<String>(){
                    {
                        this.add(string);
                    }
                });
                progressUpdater.updateProgress(progress);
            }
        });
        progressUpdater.updateProgress(100);
    }

    public void restore(Path taskPath, BackupRunningStatus runningStatus, final ProgressUpdater progressUpdater, @Nonnull Version backupVersion) throws Throwable {
        BackupHelper backupHelper = new BackupHelper();
        Persistence persistence = Persistence.getRecoveryEnabledInstance();
        Path path = taskPath.resolve("comparisons.zip");
        PersistenceEntry persistenceEntry = persistence.resolve("persistence");
        backupHelper.extractZipIntoFolder(path, persistenceEntry, false, new FileProgress(){

            public void progressUpdate(int progress, int files) {
                progressUpdater.updateProgress(progress);
            }
        });
        progressUpdater.updateProgress(100);
    }

    public boolean isVersionSupportedForRestore(@Nonnull Version backupVersion) {
        return backupVersion.isHigherOrEquals(new Version("6.2")) && ApplicationDescription.get().getVersion().isHigherOrEquals(backupVersion);
    }
}

