/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.loginmodification;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.maintenance.HelpDeskMaintenanceServerPlugin;
import com.inet.helpdesk.plugins.maintenance.server.loginmodification.LoginModificationDataAnalyzer;
import com.inet.helpdesk.plugins.maintenance.server.loginmodification.LoginModificationDataExecuter;
import com.inet.helpdesk.plugins.maintenance.server.loginmodification.api.LoginModificationTask;
import com.inet.helpdesk.plugins.maintenance.server.loginmodification.data.LoginModificationResultResponseData;
import com.inet.http.ClientMessageException;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashMap;

public class RenameLoginModificationTask
implements LoginModificationTask {
    @Override
    public String getKey() {
        return "loginmodification.renamelogin";
    }

    @Override
    public String getTitle() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("loginmodification.renamelogin.title", new Object[0]);
    }

    @Override
    public String getDescription() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("loginmodification.renamelogin.description", new Object[0]);
    }

    @Override
    public int getPriority() {
        return 200;
    }

    @Override
    public LoginModificationResultResponseData executeLoginModification(HashMap<String, String> parameters) throws ServerDataException {
        return this.executeRenameOperation(UserManager.getInstance(), parameters);
    }

    protected LoginModificationResultResponseData executeRenameOperation(UserManager manager, HashMap<String, String> parameters) {
        String newDomain = parameters.get("newDomain");
        String existingDomain = parameters.get("existingDomain");
        HelpDeskMaintenanceServerPlugin.LOGGER.info((Object)("Execution of rename domain current \"" + existingDomain + "\" new \"" + newDomain + "\""));
        RenameExecutor re = new RenameExecutor(manager, newDomain, parameters.get("existingDomain"));
        LoginModificationResultResponseData lmrrd = re.getResult("loginmodification.renamelogin.execution.count");
        if (re.getHandledLoginsCount() > 0) {
            LocalizedKey[] modifiedElements = new LocalizedKey[]{new LocalizedKey(newDomain.toUpperCase(), HelpDeskMaintenanceServerPlugin.MSG.getMsg("loginmodification.entry.name.count", new Object[]{newDomain, re.getHandledLoginsCount() + re.getAlreadyExistingCount()})), re.getProblemCount() > 0 ? new LocalizedKey(existingDomain.toUpperCase(), existingDomain + " (logins " + re.getProblemCount() + ")") : new LocalizedKey(existingDomain.toUpperCase(), "")};
            lmrrd.setModifiedEntrys(modifiedElements);
        }
        return lmrrd;
    }

    @Override
    public LoginModificationResultResponseData calcLoginModificationResult(HashMap<String, String> parameters) throws ServerDataException {
        return this.generateResults(UserManager.getInstance(), parameters);
    }

    protected LoginModificationResultResponseData generateResults(UserManager manager, HashMap<String, String> parameters) throws ClientMessageException {
        String newDomain = parameters.get("newDomain");
        String existingDomain = parameters.get("existingDomain");
        if (newDomain == null || newDomain.length() == 0 || newDomain.equalsIgnoreCase(existingDomain)) {
            throw new ClientMessageException(HelpDeskMaintenanceServerPlugin.MSG.getMsg("loginmodification.error.nodomain", new Object[0]));
        }
        HelpDeskMaintenanceServerPlugin.LOGGER.info((Object)("Infos for rename domain current \"" + existingDomain + "\" new \"" + newDomain + "\""));
        LoginModificationDataAnalyzer lmda = new LoginModificationDataAnalyzer(manager, newDomain, existingDomain);
        LoginModificationResultResponseData lmrrd = lmda.generateResult("loginmodification.renamelogin.information.count");
        lmrrd.setKey(this.getKey());
        return lmrrd;
    }

    private class RenameExecutor
    extends LoginModificationDataExecuter {
        private RenameExecutor(UserManager manager, String newDomain, String existingDomain) {
            super(manager, newDomain, existingDomain);
        }

        @Override
        protected void handleExecution(UserManager manager, UserAccount userAccount, String oldName, String newName) {
            LoginSettings login = userAccount.getLoginSettings().stream().filter(l -> "system".equals(l.getLoginSource()) && oldName.equals(l.getLoginID())).findFirst().get();
            ArrayList<LoginSettings> settingsToAdd = new ArrayList<LoginSettings>();
            settingsToAdd.add(new LoginSettings("system", newName, login.getAdditionalData()));
            ArrayList<LoginSettings> settingsToRemove = new ArrayList<LoginSettings>();
            settingsToRemove.add(login);
            manager.updateLoginSettings(userAccount.getID(), settingsToAdd, settingsToRemove);
        }
    }
}

