/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.maintenance.server.datacare;

import com.inet.helpdesk.core.data.MaintenanceConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.plugins.maintenance.HelpDeskMaintenanceServerPlugin;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCarePreview;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCareTask;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.MaintenanceLocationCleanupExtension;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.previewentries.LocationPreviewEntry;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UnreferencedLocationsDataCareTask
implements DataCareTask {
    private static final String KEY = "datacare.unreferencedlocations";

    @Nonnull
    public String getExtensionName() {
        return KEY;
    }

    @Override
    public String getTitle() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.unreferencedlocations.title", new Object[]{this.getLocationDisplayName()});
    }

    @Override
    public String getDescription() {
        return HelpDeskMaintenanceServerPlugin.MSG.getMsg("dataCare.unreferencedlocations.description", new Object[]{StringFunctions.encodeHTML((String)this.getLocationDisplayName(), (boolean)false)});
    }

    @Override
    public int getPriority() {
        return 200;
    }

    @Override
    public DataCarePreview getPreview(HashMap<String, String> parameters) throws ServerDataException {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        MaintenanceConnector connector = (MaintenanceConnector)spm.getSingleInstance(MaintenanceConnector.class);
        LocationManager locManager = LocationManager.getInstance();
        List unrelatedLocations = connector.findUnrelatedLocations();
        List instances = spm.get(MaintenanceLocationCleanupExtension.class);
        for (Object instance : instances) {
            instance.filterUnusedLocations(unrelatedLocations);
        }
        ArrayList<LocationPreviewEntry> list = new ArrayList<LocationPreviewEntry>();
        for (Integer locationId : unrelatedLocations) {
            LocationVO vo = (LocationVO)locManager.get(locationId.intValue());
            if (vo == null) continue;
            list.add(new LocationPreviewEntry().from(vo));
            if (list.size() < 6) continue;
            break;
        }
        DataCarePreview preview = new DataCarePreview();
        int entriesCount = unrelatedLocations.size();
        preview.setPreviewMsg(HelpDeskMaintenanceServerPlugin.MSG.getMsg(entriesCount > 0 ? "dataCare.unreferencedlocations.preview" : "dataCare.unreferencedlocations.nopreview", new Object[]{entriesCount}));
        preview.setExamples(list);
        return preview;
    }

    @Override
    @Nullable
    public GUID executeDelete(HashMap<String, String> parameters) throws ServerDataException {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        MaintenanceConnector connector = (MaintenanceConnector)spm.getSingleInstance(MaintenanceConnector.class);
        ArrayList<String> additionalSQL = new ArrayList<String>();
        List instances = spm.get(MaintenanceLocationCleanupExtension.class);
        for (MaintenanceLocationCleanupExtension instance : instances) {
            additionalSQL.add(instance.getAdditionsWherePart());
        }
        connector.deleteUnrelatedLocations(additionalSQL);
        LocationManager.getInstance().reloadFromDatabase();
        return null;
    }

    private String getLocationDisplayName() {
        return HDUsersAndGroups.FIELD_LOCATION_ID.getLabel();
    }
}

